#!/bin/sh

log()
{
    echo "[$(date)]  $*"
}

meas_log()
{
    log "Compile and execute $*"
}

exit_on_error()
{
    if [ "$1" != "0" ]
	then
	echo "Error found. Cowardly bailing out!"
	exit 1
    fi
}

test_ass()
{
    meas_log "Assembler code"
    as -o hello.o hello.S && ld -s -o hello hello.o 
    exit_on_error $?
    
    strace ./hello 2> /tmp/ass.txt >/dev/null
    exit_on_error $?
    ASS_SYS=$(cat /tmp/ass.txt | grep -v  exec | grep -v detach | wc -l)
}

test_c()
{
    meas_log "C code"
    gcc -o hello hello.c
    exit_on_error $?

    strace ./hello 2> /tmp/c.txt  >/dev/null
    exit_on_error $?

    C_SYS=$(cat /tmp/c.txt | grep -v execve | grep -v detached | wc -l)
}

test_cpp()
{
    meas_log "C++ code"
    g++ -o hello hello.cpp
    exit_on_error $?

    strace ./hello 2> /tmp/cpp.txt  >/dev/null
    exit_on_error $?

    CPP_SYS=$(cat /tmp/cpp.txt | grep -v execve | grep -v detached | wc -l)
}

test_java_vm()
{
    meas_log "Java code run in a vm"
    javac Hello.java 
    exit_on_error $?

    strace java Hello 2> /tmp/javavm.txt >/dev/null
    exit_on_error $?

    JAVA_VM_SYS=$(cat /tmp/javavm.txt | grep -v exec | grep -v detached | wc -l)
}

test_java_nat()
{
    meas_log "Java code run natively"
    gcj Hello.java -o Hello --main=Hello
    exit_on_error $?

    strace ./Hello 2>/tmp/javan.txt    >/dev/null
    exit_on_error $?
    JAVA_NAT_SYS=$( cat /tmp/javan.txt | grep -v execve | grep -v detached | wc -l)
    
}


test_perl()
{
    meas_log "perl"

    strace ./hello.pl 2>/tmp/perl.txt    >/dev/null
    exit_on_error $?
    PERL_SYS=$( cat /tmp/perl.txt | grep -v execve | grep -v detached | wc -l)
}

test_ruby()
{
    meas_log "ruby"

    strace ./hello.rb 2>/tmp/ruby.txt    >/dev/null
    exit_on_error $?
    RUBY_SYS=$( cat /tmp/ruby.txt | grep -v execve | grep -v detached | wc -l)
}

test_python()
{
    meas_log "python"

    strace ./hello.py 2>/tmp/python.txt    >/dev/null
    exit_on_error $?
    PYTHON_SYS=$( cat /tmp/python.txt | grep -v execve | grep -v detached | wc -l)
}

test_bash()
{
    meas_log "bash"

    strace ./hello.sh 2>/tmp/bash.txt    >/dev/null
    exit_on_error $?
    BASH_SYS=$( cat /tmp/bash.txt | grep -v execve | grep -v detached | wc -l)
}

# 
#  exec the test
#
test_ass
test_c
test_cpp
test_java_vm
test_java_nat
test_perl
test_python
test_ruby
test_bash

# 
#  print results
#
echo " "
echo " "
printf "+---------------------------+\n"
printf "| syscalls    \tLanguage    |\n"
printf "|---------------------------+\n"
stats() {
    printf " %4d          Assembler   |\n" $ASS_SYS
    printf " %4d          C           |\n" $C_SYS
    printf " %4d          C++         |\n" $CPP_SYS
    printf " %4d          Ruby        |\n" $RUBY_SYS
    printf " %4d          Bash        |\n" $BASH_SYS
    printf " %4d          Perl        |\n" $PERL_SYS
    printf " %4d          Java native |\n" $JAVA_NAT_SYS
    printf " %4d          Java in vm  |\n" $JAVA_VM_SYS
    printf " %4d          Python      |\n" $PYTHON_SYS
}
stats | sort  -n | awk ' { printf "|%s\n", $0}'
printf "+---------------------------+\n"
echo " "
echo " "
echo " .... this is NOT a scientific study and it's NOT a fair comparison"
echo "Yet, kind of fun ;)"
echo " "



