
//Räknar längden på en sträng, exklusive avslutande nollan
int strlength(char *str) {
    int i = 0;
    while (*str) {
        i++;
        str++;
    }
    return i;
}

//Reverserar strängen s in place. Returnerar argumentet. 
char *reverse(char *str) {
    int len = strlength(str);
    char *start = str;
    //end ska peka på sista tecknet (alltså inte avslutande nollan.)
    char *end = str + (len - 1);
    char temp;
    //Byt plats på tecken i början och tecken i slutet av strängen
    //tills s "går förbi" end
    while (end > str) {
        temp = *end;
        *end = *str;
        *str = temp;
        end--;
        str++;
    }
    return start;
}

//Letar upp en substräng (pattern) i en söksträng (str) och returnerar
//en pekare till den första platsen där substrängen uppträder
//i söksträngen. Returnerar 0 om ingen sådan plats hittas. 
//Detta är en "naiv" algoritm. För mer effektiva alternativ är
//wikipedia-sidan en bra startpunkt: 
//https://en.wikipedia.org/wiki/String_searching_algorithm
char *substr(char *pattern, char *str) {
    int i = 0;
    int patternlength = strlength(pattern);
    int strleng = strlength(str);
    //Vi säger att en tom substräng finns först i söksträngen.
    if (patternlength == 0) {
        return str;
    }    
    //Om substrängen är längre än söksträngen
    if (patternlength > strleng) {
        return 0;
    }    
    
    //Undersök varje möjlig startpunkt i strängen str för att se om där finns
    //en kopia av pattern. Avbryt loopen när pattern är längre än det är 
	//tecken kvar att undersöka i str.
    while (*(str + (patternlength -1))) {
        for(i = 0; i < patternlength; i++) {
            //Så fort ett tecken inte matchar, bryt for-loopen
            if (*(str + i) != *(pattern + i)) {
                break;
            }
        }
        //Om vi kom igenom hela pattern utan att ett tecken som inte matchar
		//i str
        if (i == patternlength) {
            return str;
        }
        //i nästa iteration, undersök nästa startpunkt i str
        str++;
    }
    return 0;
}