#include "resizable.h"
#include <stdlib.h>

//Skapa en ny dynamisk array på heapen. Returnera en pekare till den. 
resizableArray newResizableArray(int n) {
    //Allokera plats för structen som håller reda på storleken för 
    //arrayen och var den finns i minnet
    resizableArray ra = malloc(sizeof(resizableArray));
    //Allokera själva lagringsplatsen för elementen i arrayen. 
    ra->data = calloc(sizeof(char), n); 
    ra->size = n;
    return ra;
}

//Lämna tillbaka det minne som allokerats (reserverats) för arrayen. 
void freeResizableArray(resizableArray ra) {
    //Observera ordningen för de två följande raderna. 
    free(ra->data);
    free(ra);
}
    
//Gör storleken på ra större. Parametern wantedsize anger 
//en önskad storlek på arrayen. resize kommer dock alltid att 
//minst dubblera storleken på arrayen. 
void resize(resizableArray ra, int wantedsize) {
    
    int i;
    if (wantedsize < ra->size * 2) {
        wantedsize = ra->size * 2;
    }
    //Allokera nytt, större utrymme
    char *newdata = calloc(sizeof(char), wantedsize);
    //Kopiera alla gamla data till det nya utrymmet
    for(i = 0; i < ra->size; i++) {
        newdata[i] = ra->data[i];
    }
    //Lämna tillbaka det gamla utrymmet 
    free(ra->data);
    //Uppdatera structen som håller reda på den dynamiska arrayen. 
    ra->data = newdata;
    ra->size = wantedsize;
}

//Returnerar elementet på plats i i ra. Om i är ett för stort index 
//förstoras ra. 
char getElement(resizableArray ra, int i) {
    //Jämför med ra->size -1 eftersom arrayers index startar på 0. 
    if (i > ra->size - 1) {
        resize(ra, i+1);
    }
    
    return ra->data[i];
}

//Sätter elementet på plats i till c. Om i är ett för stort index
//förstoras ra. 
void setElement(resizableArray ra, int i, char c) {
    //Jämför med ra->size -1 eftersom arrayers index startar på 0. 
    if (i > ra->size - 1) {
        resize(ra, i+1);
    }
    
    ra->data[i] = c;
}

//Returnerar antalet element som ra just nu innehåller. 
int arraysize(resizableArray ra) {
    return ra->size;
}