//Header filer-------------------------------------------------------------
#include <xc.h>
//Macros & defines---------------------------------------------------------
#define _XTAL_FREQ 4000000   // __delay_ms/us(x)

/* Systemet har tv 7seg displayer fr tvsiffriga decimala tal. 
 * Display 0 representerar ettorna, display 1 representerar tiorna.
 * Dessa variabler r aktiv LG.            */
#define BL0 LATAbits.LATA7  //Blank Enable display 0. Stnger av alla dioder p displayen.
#define LT LATAbits.LATA6   //Lamp Test. Visar en '8' p displayen nr LG.
#define BL1 LATAbits.LATA0  //Blank Enable display 1

/* BCD nibble som matas till D-ingngarna p 74H4511 BCD 7-segment driver*/
#define D0 LATBbits.LATB4
#define D1 LATBbits.LATB5
#define D2 LATBbits.LATB6
#define D3 LATBbits.LATB7

/* Binr nibble som matar ut 'rvrdet' till PLC:n */
#define b3 LATBbits.LATB3
#define b2 LATBbits.LATB2
#define b1 LATBbits.LATB1
#define b0 LATBbits.LATB0

/* Hr kalibreras vrdet som ska verensstmma med 30c p NTC motstndet */
#define THERM_MAX 127

//Configuration Bits-------------------------------------------------------  //boilerplate config pilfered from example sheet.
//Se C:\Program Files\Microchip\xc8\Vx.xx\docs\pic_chipinfo
//Oscillator Intern, Watchdog timer disabled, Power-Up timer enabled
//Brownout Reset Disable, Low-Voltage Programming Disabled, Unprotect memory,
//MasterClear Input Enabled, Debug disabled,FCM/IESO disabled
#pragma config CPD=OFF, BOREN=OFF, IESO=OFF, FOSC=INTOSC, FCMEN=OFF, MCLRE=ON,\
 WDTE=OFF, CP=OFF, PWRTE=ON, CLKOUTEN=OFF //Config Word 1
#pragma config PLLEN=OFF, WRT=OFF, STVREN=ON, BORV=LO, LVP=OFF //Config Word 2

//Global Variables - Declaration-------------------------------------------
volatile unsigned char halfsec, therm;  //Variabler frn externa givare och interrupt rutiner.
unsigned char alarm;

/*halfsec - rknar halvsekunder*/
/*therm - uppmtta termometer vrde*/
/*alarm - flaggbit som anvnds i ISR fr att avgra om display ska blinka. 1:a blinka, 0:a statisk */

//Funktionsprototyper------------------------------------------------------
void init(void);
/* Initierar interna register. Obs. mste gras innan huvudprogrammet */
void interrupt isr(void);
/* Interrupt subrutin som exekveras ungefr varje halvsekund  (kan justeras i timer instllnignar) */
char AD_omv(char ADkanal); 
/* Tar nummret p ingngen som parameter och A/D omvandlar den. Parametern anvnder binra tal t.ex. 0,1,2,4,8 osv. */
void BIN_out(unsigned char arvarde);
/* Lgger ut ett heltal 'arvarde' som binrt p 4 utgngar b0-b3. */
void BCD_out(unsigned char arvarde);
/* Lgger ut ett BCD tal 'arvarde' p utgngarna D0-D3. */
unsigned char measure_rps(void);
/* Mter varvtalet [enhet varv/5sek] beroende p antalet rknade spnningspulser */
void therm_check(void);
/* lser av termometern och ser om den verskrider maximum varvid den aktiverar larmet. */