/*
 * File:   main.c
 * Author: john croft
 *
 * Created on den 19 april 2016, 23:18
 */

//Header filer-------------------------------------------------------------
#include <xc.h>
//Macros & defines---------------------------------------------------------
#define _XTAL_FREQ 4000000   // __delay_ms/us(x)
#define SJU_SEG_H LATAbits.LATA0
#define LE LATAbits.LATA6
#define BL LATAbits.LATA7
#define THERM_MAX 30

//Configuration Bits-------------------------------------------------------  //boilerplate config pilfered from example sheet.
//Se C:\Program Files\Microchip\xc8\Vx.xx\docs\pic_chipinfo
//Oscillator Intern, Watchdog timer disabled, Power-Up timer enabled
//Brownout Reset Disable, Low-Voltage Programming Disabled, Unprotect memory,
//MasterClear Input Enabled, Debug disabled,FCM/IESO disabled
#pragma config CPD=OFF, BOREN=OFF, IESO=OFF, FOSC=INTOSC, FCMEN=OFF, MCLRE=ON,\
 WDTE=OFF, CP=OFF, PWRTE=ON, CLKOUTEN=ON //Config Word 1
#pragma config PLLEN=OFF, WRT=OFF, STVREN=ON, BORV=LO, LVP=OFF //Config Word 2

//Funktionsprototyper------------------------------------------------------
void init(void);
void interrupt isr(void);
char AD_omv(char ADkanal); 
unsigned char sju_seg(unsigned char varvtal);

//Globala Variabler--------------------------------------------------------
unsigned char halfsec = 0;
unsigned char ettor, tior;
unsigned char therm = 0;       
    
//Huvudprogram-------------------------------------------------------------
void main(void) {
    unsigned char varvtal = 0;
    
    init();     
    while(1)    
    {
        CCPR3L = AD_omv(1);         //Det som uppmtts p AN1 (brvrdet) matas direkt ut som en PWM signal [0-255] p RA3.
        therm = AD_omv(2);          //NTC motstnd. Mste kalibreras!!!
        
        //Vi mter RVRDET var 5:e sekund
        if (halfsec == 10)      
        {
            halfsec = 0;
            varvtal = TMR0 / 15;    //15 pulser i ett varv. Antal varv under 5 sekunder.
            TMR0 = TMR0 % 15;       //TMR0 fr vrdet av resten, vilket ger en noggrannare mtning n om vi slopar resten. ALT. TMR0 = 0;
            
            LATB = varvtal;         //Nollstller alltid b7-b4
            
            if (therm < THERM_MAX)
            {
                LATB |= (sju_seg(varvtal) << 4);   //Skriver varvtalet och 'ettor' rakt ut p PORTB istllet gra det bit fr bit. Tillter oss att smidigt anvnda hela banken.
                LE = 0; LE = 1;    //'Lser' vrdet p sjusegmentsdisplayen med en snabb puls lg.
                if (!BL)
                    BL = 1;     //Ifall vi har stngt av displayen s stts den p igen.
            }
            else
            {
                SJU_SEG_H = 0;      //Slcker den displayen fr tiorna
                LATB |= (0x8 << 4);  //Lgger ut en tta p lga displayen
                LE = 0; LE = 1;     //Latchar vrdet
            }
        } 
    }
}

void init() {
    OSCCON = 0b01101000;  //Fosc = 4MHz == 1101
    LATA=0x00; //Nollstller alla bitar i PORTA
    LATB=0x00; //Nollstller alla bitar i PORTB 
    ANSELA = 0b00000110;    //0 = Digital, 1 = Analog
    ANSELB = 0b00000000;
    TRISA  = 0b00110110;    //Ingngar: MCLR(RA5), T0CKI(RA4), AN1(RA1), AN2(RA2) 
    TRISB  = 0b00000000;    //Stter alla ben p PORTB till utgngar.
    
    //Pulsrknare-----------------------------------------------------------------------------
    TMR0 = 0x00;
    CPSCON0 = 0X00;     //select ext. clock source
    OPTION_REG = 0b00101000;     //ext. clock source, rising edge, prescaler disabled(1:1)
    
    //Timer1 & overflow interrupt---------------------------------------------------------------
    T1CON = 0b00110001;    //Clock Source=Fosc/4, Prescaler 1:8, Internal Clock, Timer1 ON
    T1GCON =0b00000000;     //Gate control register; all fucntions disabled.
    TMR1L = 0xDF;        
    TMR1H = 0x0B;
    PIE1 = 0x01;         //TMR1 overflow interrupt enable
    INTCON = 0b11000000; //Global and peripheral interrupt enable
    
    //ADC-------------------------------------------------------------------------------------
    ADCON1 = 0b01000000;     //Vnsterjusterat, A/D Conversion Clock Fosc/4
    ADCON0 = 0b00000001;     //AN1, ADON     
    
    //Pulse Width Modulation----------------------------------------------------------------
    //OBS! CCP3(RA3) anvnds till PWM!
    CCP3CON = 0b00001100;   //2 LSB frkastade, CCP3 i PWM mode
    CCPTMRS = 0x00;          //Vlj s att CCP3 anvnder Timer 2.
    PR2 = 254;              //D CCPR3L := 255 nskar vi tp := Tpwm, drfr 1020 := (PR2+1)*4
    T2CON = 0b00000110;      //Timer 2 ON, Prescaler=16. Ger Fpwm = 245 Hz.
    
    //7 segmentsdisplayen
    LE = 1; //Latch 
    BL = 1; //Blank
    
}

//Interrupt routine-------------------------------------------------------
void interrupt isr(void)
{
    if (PIR1bits.TMR1IF && PIE1bits.TMR1IE)     //Vilken interrupt r aktuell
  {
        halfsec++;              //rknar tv halvsekunder innan den incrementerar sekundmtaren.
        
        if(therm >= THERM_MAX)
            BL = !BL;           //Blinkar varje halvsekund.
        
        TMR1L = 0xDF;               //terstller TMR1 s att
        TMR1H = 0x0B;               //delay == 0,5 s
        
        PIR1bits.TMR1IF = 0;        //Nollstller interruptflaggan
    }
}

char AD_omv(char ADkanal){
    ADCON0 = (ADCON0 & 0b10000011) | (ADkanal << 2);  //Aktiverar rtt AD kanal.
    __delay_us(5);              //delay 5us fr Tacq.
    ADCON0bits.GO = 1;       //AD omvandling startar.
    while(ADCON0bits.GO);    //Vntar p registertillstndet att frndras.
    
    return ADRESH;          //Returnerar 8 MSB.
}

unsigned char sju_seg(unsigned char varvtal)
{
    //7Seg display
    tior = varvtal / 10;
    if (tior)               //Villkorligt tnder eller slcker den hga 7seg indikatorn.
        SJU_SEG_H = 1;
    else
        SJU_SEG_H = 0;
    
    ettor = varvtal % 10;
    
    return ettor;                //skifta upp 4bitars talet till Most Significant Nibble.
}