--  D-flipflop register w/ async reset (active LOW).

LIBRARY ieee; 
USE ieee.std_logic_1164.all; 


ENTITY  D_register IS 
	GENERIC ( N : INTEGER := 8);
	PORT ( 	D						: IN STD_LOGIC_VECTOR(N-1 DOWNTO 0); 
			Aresetn, Clock, Enable 	: IN STD_LOGIC; 
			Q 						: OUT STD_LOGIC_VECTOR(N-1 DOWNTO 0)
	); 
END D_register;

ARCHITECTURE behv OF D_register IS 
	SIGNAL D_in	: STD_LOGIC_VECTOR(N-1 DOWNTO 0);
BEGIN

	with Enable select	-- When not enabled, output is fed back into input.
	D_in <= D when '1',
			Q when others;

	PROCESS (Aresetn, Clock ) 
		BEGIN 
			IF Aresetn = '0' THEN 
				Q <= (OTHERS => '0'); 
			ELSIF rising_edge(Clock) THEN 
				Q <= D_in ; 
			END IF ; 
	END PROCESS ;
END behv ;