--****************************************************************************************************************--
--! @RAM
--! @ RAM array implementation 

--! Author: John William Croft 
--! CID: croft
--****************************************************************************************************************--

----------------------------------------------------- Libraries ----------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;

--! Local libraries
library work;

----------------------------------------------------- Entity -------------------------------------------------------
--! Entity/Package Description


entity RAM_test is
	generic(	width:		integer:=4;
				addr_bits:	integer:=1);
				
	port (	clk:		in	std_logic;
			read:		in	std_logic;
			write:		in	std_logic;
			addr:		in	std_logic_vector(addr_bits-1 downto 0);
			data_in:	in	std_logic_vector(width-1 downto 0);
			data_out:	out	std_logic_vector(width-1 downto 0)
	);
end entity RAM_test;

architecture behv of RAM_test is
	--type ram_type is array (0 to (2**addr_bits)-1) of std_logic_vector(width-1 downto 0);
	--signal tmp_ram : ram_type := (others => (others => '0'));
	
	-- array of array 
	type nibble is array (3 downto 0) of integer;
	type mem is array (1 downto 0) of nibble;
	
	--signal mem2X4 : mem := (others => (others => 0));
	signal mem2X4 : mem := ((1,2,3,4), (4,3,2,1));
	
	---- True 2D array (may not be synthesizable!)
	--type T_2D is array(3 downto 0, 1 downto 0) of integer;
	--signal X_2D : T_2D:= (others => (others => 0));
	
begin
	mem2X4 <= (others => (1,0,1,0));
	
	---- True 2D array (may not be synthesizable!)
	--X_2D <= ((0,0), (1,1), (2,2), (0,3));
	--X_2D(3,1) <= 4;
	
	
end architecture behv;

component RAM_test is
	generic(	width:		integer:=4;
				addr_bits:	integer:=1);
				
	port (	clk:		in	std_logic;
			read:		in	std_logic;
			write:		in	std_logic;
			addr:		in	std_logic_vector(addr_bits-1 downto 0);
			data_in:	in	std_logic_vector(width-1 downto 0);
			data_out:	out	std_logic_vector(width-1 downto 0)
	);
end component RAM_test;
