-- 8bit CLA from book pg. 272

library ieee;
use ieee.std_logic_1164.all;

entity CLA_from_book is 
	port( 	S	: out std_logic_vector(7 downto 0);
			a	: in std_logic_vector(7 downto 0);
			b	: in std_logic_vector(7 downto 0);
			Cin	: in std_logic := '0';
			Cout: out std_logic );
end entity;

architecture imp1 of CLA_from_book is
	signal p, g, p2, g2, p4, g4, p8, g8: std_logic_vector(7 downto 0);
	signal coi: std_logic_vector(8 downto 0);
begin
	-- input stage of PG cells
	p <= a xor b;
	g <= a and b;
	
	p2 <= p and ('0' & p(7 downto 1));
	g2 <= ('0' & g(7 downto 1)) or (g and ('0' & p(7 downto 1)));
	p4 <= p2 and ("00" & p2(7 downto 2));
	g4 <= ("00" & g2(7 downto 2)) or (g2 and ("00" & p2(7 downto 2)));
	p8 <= p4 and ("0000" & p4(7 downto 4));
	g8 <= ("0000" & g4(7 downto 4)) or (g4 and ("0000" & p4(7 downto 4)));
			
	coi(0) <= Cin;
	coi(8) <= g8(0) or (Cin and p8(0));
	coi(4) <= g4(0) or (Cin and p4(0));
	coi(2) <= g2(0) or (Cin and p2(0));
	coi(1) <= g(0) or (Cin and p(0));
	
	coi(6) <= g2(4) or (coi(4) and p2(4));
	coi(5) <= g(4) or (coi(4) and p(4));
	coi(3) <= g(2) or (coi(2) and p(2));
	
	coi(7) <= g(6) or (coi(6) and p(6));
	Cout <= coi(8);
	S <= coi(7 downto 0) XOR p;  -- also can be expressed as (cio(7 downto 0) XOR a XOR b);
	end imp1;