--****************************************************************************************************************--
--! @ Ripple Carry Adder

--! Author: John William Croft 
--! CID: croft
--****************************************************************************************************************--

----------------------------------------------------- Libraries ----------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use work.alu_pkg.all;
----------------------------------------------------- Entity -------------------------------------------------------

entity RCA is
	generic(N : integer := 8);
	port (	S : out std_logic_vector(N-1 downto 0);
			A : in std_logic_vector(N-1 downto 0);
			B : in std_logic_vector(N-1 downto 0);
			Cin : in std_logic := '0';
			Cout : out std_logic
	
	);
end entity RCA;

architecture struct of RCA is
	signal c_internal : std_logic_vector(N downto 0);
begin
	Cout <= c_internal(N);
	c_internal(0) <= Cin;
	
	G1	:	FOR i in 0 to N-1 generate
		FAi :  FA PORT MAP( Cin => c_internal(i) , A => A(i), B => B(i), S => S(i), Cout => c_internal(i+1) );
	end generate;
end architecture struct;
