/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.EEGLABChat;
import java.awt.Color;
import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ChatPane
extends JTextPane {
    String icoSad;
    String icoSmily;
    String icoTongue;
    String icoWinking;
    String icoOh;
    EEGLABChat llamaChat;

    ChatPane(EEGLABChat lc) {
        this.llamaChat = lc;
        this.setEditable(false);
        this.setContentType("text/html");
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet css = new StyleSheet();
        css.addRule("BODY{ margin : 0;}");
        css.addRule("P{ margin : 0;}");
        css.addRule("A{ color:#0000FF; text-decoration:underline;}");
        kit.setStyleSheet(css);
        this.setEditorKit(kit);
        this.setBackground(new Color(249, 249, 250));
        this.icoSad = "<img src=\"" + lc.locationURL + "images/sad.gif\" height=\"14\" width=\"14\">";
        this.icoSmily = "<img src=\"" + lc.locationURL + "images/smiley.gif\" height=\"14\" width=\"14\">";
        this.icoOh = "<img src=\"" + lc.locationURL + "images/oh.gif\" height=\"14\" width=\"14\">";
        this.icoTongue = "<img src=\"" + lc.locationURL + "images/tongue.gif\" height=\"14\" width=\"14\">";
        this.icoWinking = "<img src=\"" + lc.locationURL + "images/winking.gif\" height=\"14\" width=\"14\">";
        this.addHyperlinkListener(lc.myHyperlinkListener);
    }

    public void sendText(String un, String message, int size) {
        this.sendText(un, message, false, size);
    }

    public void sendText(String un, String message, boolean whisper, int size) {
        StringBuffer buff = new StringBuffer();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)this.getEditorKit();
        if (un == null || this.llamaChat.username == null) {
            return;
        }
        if (!"server".equals(un)) {
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
        }
        message = message.replaceAll("\n", "<br>");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        buff.append("<font size=" + size + "><b>" + dateFormat.format(date) + " </b></font>");
        if (this.llamaChat.username.equals(un)) {
            buff.append("<font color=#009900 size=" + size + "><b>");
        } else if (un.equals("server")) {
            buff.append("<font color=#990000 size=" + size + "><b>");
        } else {
            buff.append("<font color=#000099 size=" + size + "><b>");
        }
        buff.append(un);
        buff.append("</b></font>");
        buff.append("&nbsp;&nbsp;:&nbsp;");
        if (whisper) {
            buff.append("<i>");
        }
        char[] tmp = message.toCharArray();
        int start = 0;
        int end = 0;
        while (end < tmp.length - 1) {
            if (tmp[end] == ';') {
                if (tmp[end + 1] == ')') {
                    if (end - start > 0) {
                        buff.append(tmp, start, end - start);
                    }
                    buff.append(this.icoWinking);
                    end += 2;
                    start = end--;
                }
            } else if (tmp[end] == ':') {
                switch (tmp[end + 1]) {
                    case ')': {
                        if (end - start > 0) {
                            buff.append(tmp, start, end - start);
                        }
                        buff.append(this.icoSmily);
                        end += 2;
                        start = end--;
                        break;
                    }
                    case '(': {
                        if (end - start > 0) {
                            buff.append(tmp, start, end - start);
                        }
                        buff.append(this.icoSad);
                        end += 2;
                        start = end--;
                        break;
                    }
                    case 'P': {
                        if (end - start > 0) {
                            buff.append(tmp, start, end - start);
                        }
                        buff.append(this.icoTongue);
                        end += 2;
                        start = end--;
                        break;
                    }
                    case 'o': {
                        if (end - start > 0) {
                            buff.append(tmp, start, end - start);
                        }
                        buff.append(this.icoOh);
                        end += 2;
                        start = end--;
                    }
                }
            } else if (end + 10 < tmp.length && tmp[end] == 'h' && tmp[end + 1] == 't' && tmp[end + 2] == 't' && tmp[end + 3] == 'p' && tmp[end + 4] == ':' && tmp[end + 5] == '/' && tmp[end + 6] == '/') {
                if (end - start > 0) {
                    buff.append(tmp, start, end - start);
                }
                int index = 7;
                while (index < tmp.length && Pattern.matches("[\\w.:/\\?\\=&%_\\-~]", CharBuffer.wrap(tmp, end + index, 1))) {
                    ++index;
                }
                buff.append("<a href=\"");
                buff.append(tmp, end, index);
                buff.append("\">");
                buff.append(tmp, end, index);
                buff.append("</a>");
                end += index;
                start = end--;
            }
            ++end;
        }
        if (start < tmp.length) {
            buff.append(tmp, start, tmp.length - start);
        }
        if (whisper) {
            buff.append("</i>");
        }
        if (buff.length() > 0) {
            try {
                kit.insertHTML(doc, doc.getLength(), buff.toString(), 0, 0, HTML.Tag.FONT);
                this.setCaretPosition(doc.getLength());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (message.startsWith("afk") || message.startsWith("brb")) {
            this.llamaChat.afks.add(un);
            this.llamaChat.updateList();
        } else if (this.llamaChat.afks.contains(un)) {
            this.llamaChat.afks.remove(un);
            this.llamaChat.updateList();
        }
    }

    public void changeFontSize(int fontSize) {
        StringBuffer buff = new StringBuffer();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)this.getEditorKit();
    }

    public void error(String s) {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)this.getEditorKit();
        try {
            kit.insertHTML(doc, doc.getLength(), "<font color=#CC0000><b>ERROR  : " + s + "<b><br></font>", 0, 0, HTML.Tag.FONT);
            this.setCaretPosition(doc.getLength());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

