/*
 * Decompiled with CFR 0.152.
 */
package gifAnimation;

import gifAnimation.GifEncoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GifMaker
implements PConstants {
    public static final int DISPOSE_NOTHING = 0;
    public static final int DISPOSE_KEEP = 1;
    public static final int DISPOSE_RESTORE_BACKGROUND = 2;
    public static final int DISPOSE_REMOVE = 3;
    private GifEncoder encoder;
    private PApplet parent;

    public GifMaker(PApplet pApplet, String string) {
        this.parent = pApplet;
        pApplet.registerMethod("dispose", (Object)this);
        this.encoder = this.initEncoder(string);
    }

    public GifMaker(PApplet pApplet, String string, int n) {
        this(pApplet, string);
        this.setQuality(n);
    }

    public GifMaker(PApplet pApplet, String string, int n, int n2) {
        this(pApplet, string, n);
        this.setTransparent(n2);
    }

    public void dispose() {
        this.finish();
    }

    private GifEncoder initEncoder(String string) {
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.start(this.parent.savePath(string));
        return gifEncoder;
    }

    public void setDelay(int n) {
        this.encoder.setDelay(n);
    }

    public void setDispose(int n) {
        this.encoder.setDispose(n);
    }

    public void setQuality(int n) {
        this.encoder.setQuality(n);
    }

    public void setRepeat(int n) {
        this.encoder.setRepeat(n);
    }

    public void setSize(int n, int n2) {
        this.encoder.setSize(n, n2);
    }

    public void setTransparent(int n) {
        this.setTransparent((int)this.parent.red(n), (int)this.parent.green(n), (int)this.parent.blue(n));
    }

    public void setTransparent(float f, float f2, float f3) {
        this.setTransparent((int)f, (int)f2, (int)f3);
    }

    public void setTransparent(int n, int n2, int n3) {
        this.encoder.setTransparent(new Color(n, n2, n3));
    }

    public void addFrame() {
        this.parent.loadPixels();
        this.addFrame(this.parent.pixels, this.parent.width, this.parent.height);
    }

    public void addFrame(PImage pImage) {
        this.addFrame(pImage.pixels, pImage.width, pImage.height);
    }

    public void addFrame(int[] nArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        this.encoder.addFrame(bufferedImage);
    }

    public boolean finish() {
        return this.encoder.finish();
    }
}

