/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.sccn;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;

public class LSL {
    public static final double IRREGULAR_RATE = 0.0;
    public static final double DEDUCED_TIMESTAMP = -1.0;
    public static final double FOREVER = 3.2E7;
    static dll inst;

    public static int protocol_version() {
        return inst.lsl_protocol_version();
    }

    public static int library_version() {
        return inst.lsl_library_version();
    }

    public static double local_clock() {
        return inst.lsl_local_clock();
    }

    public static StreamInfo[] resolve_streams(double wait_time) {
        Pointer[] buf = new Pointer[1024];
        int num = inst.lsl_resolve_all(buf, buf.length, wait_time);
        StreamInfo[] res = new StreamInfo[num];
        for (int k = 0; k < num; ++k) {
            res[k] = new StreamInfo(buf[k]);
        }
        return res;
    }

    public static StreamInfo[] resolve_streams() {
        return LSL.resolve_streams(1.0);
    }

    public static StreamInfo[] resolve_stream(String prop, String value, int minimum, double timeout) {
        Pointer[] buf = new Pointer[1024];
        int num = inst.lsl_resolve_byprop(buf, buf.length, prop, value, minimum, timeout);
        StreamInfo[] res = new StreamInfo[num];
        for (int k = 0; k < num; ++k) {
            res[k] = new StreamInfo(buf[k]);
        }
        return res;
    }

    public static StreamInfo[] resolve_stream(String prop, String value, int minimum) {
        return LSL.resolve_stream(prop, value, minimum, 3.2E7);
    }

    public static StreamInfo[] resolve_stream(String prop, String value) {
        return LSL.resolve_stream(prop, value, 1, 3.2E7);
    }

    public static StreamInfo[] resolve_stream(String pred, int minimum, double timeout) {
        Pointer[] buf = new Pointer[1024];
        int num = inst.lsl_resolve_bypred(buf, buf.length, pred, minimum, timeout);
        StreamInfo[] res = new StreamInfo[num];
        for (int k = 0; k < num; ++k) {
            res[k] = new StreamInfo(buf[k]);
        }
        return res;
    }

    public static StreamInfo[] resolve_stream(String pred, int minimum) {
        return LSL.resolve_stream(pred, minimum, 3.2E7);
    }

    public static StreamInfo[] resolve_stream(String pred) {
        return LSL.resolve_stream(pred, 1, 3.2E7);
    }

    static void check_error(int[] ec) throws Exception {
        if (ec[0] < 0) {
            switch (ec[0]) {
                case -1: {
                    throw new TimeoutException("The operation failed due to a timeout.");
                }
                case -2: {
                    throw new LostException("The stream has been lost.");
                }
                case -3: {
                    throw new ArgumentException("An argument was incorrectly specified (e.g., wrong format or wrong length).");
                }
                case -4: {
                    throw new InternalException("An internal internal error has occurred.");
                }
            }
            throw new Exception("An unknown error has occurred.");
        }
    }

    static {
        switch (Platform.getOSType()) {
            case 2: {
                inst = (dll)Native.loadLibrary((String)(Platform.is64Bit() ? "liblsl64.dll" : "liblsl32.dll"), dll.class);
                break;
            }
            case 0: {
                inst = (dll)Native.loadLibrary((String)(Platform.is64Bit() ? "liblsl64.dylib" : "liblsl32.dylib"), dll.class);
                break;
            }
            default: {
                inst = (dll)Native.loadLibrary((String)(Platform.is64Bit() ? "lsl64" : "liblsl32.so"), dll.class);
                if (inst != null) break;
                inst = (dll)Native.loadLibrary((String)"liblsl.so", dll.class);
            }
        }
    }

    public static interface dll
    extends Library {
        public int lsl_protocol_version();

        public int lsl_library_version();

        public double lsl_local_clock();

        public Pointer lsl_create_streaminfo(String var1, String var2, int var3, double var4, int var6, String var7);

        public void lsl_destroy_streaminfo(Pointer var1);

        public String lsl_get_name(Pointer var1);

        public String lsl_get_type(Pointer var1);

        public int lsl_get_channel_count(Pointer var1);

        public double lsl_get_nominal_srate(Pointer var1);

        public int lsl_get_channel_format(Pointer var1);

        public String lsl_get_source_id(Pointer var1);

        public int lsl_get_version(Pointer var1);

        public double lsl_get_created_at(Pointer var1);

        public String lsl_get_uid(Pointer var1);

        public String lsl_get_session_id(Pointer var1);

        public String lsl_get_hostname(Pointer var1);

        public Pointer lsl_get_desc(Pointer var1);

        public String lsl_get_xml(Pointer var1);

        public Pointer lsl_create_outlet(Pointer var1, int var2, int var3);

        public void lsl_destroy_outlet(Pointer var1);

        public int lsl_push_sample_ftp(Pointer var1, float[] var2, double var3, int var5);

        public int lsl_push_sample_dtp(Pointer var1, double[] var2, double var3, int var5);

        public int lsl_push_sample_itp(Pointer var1, int[] var2, double var3, int var5);

        public int lsl_push_sample_stp(Pointer var1, short[] var2, double var3, int var5);

        public int lsl_push_sample_ctp(Pointer var1, byte[] var2, double var3, int var5);

        public int lsl_push_sample_strtp(Pointer var1, String[] var2, double var3, int var5);

        public int lsl_push_sample_buftp(Pointer var1, byte[][] var2, int[] var3, double var4, int var6);

        public int lsl_push_chunk_ftp(Pointer var1, float[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_ftnp(Pointer var1, float[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_dtp(Pointer var1, double[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_dtnp(Pointer var1, double[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_itp(Pointer var1, int[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_itnp(Pointer var1, int[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_stp(Pointer var1, short[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_stnp(Pointer var1, short[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_ctp(Pointer var1, byte[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_ctnp(Pointer var1, byte[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_strtp(Pointer var1, String[] var2, long var3, double var5, int var7);

        public int lsl_push_chunk_strtnp(Pointer var1, String[] var2, long var3, double[] var5, int var6);

        public int lsl_push_chunk_buftp(Pointer var1, byte[][] var2, long[] var3, long var4, double var6, int var8);

        public int lsl_push_chunk_buftnp(Pointer var1, byte[][] var2, long[] var3, long var4, double[] var6, int var7);

        public int lsl_have_consumers(Pointer var1);

        public int lsl_wait_for_consumers(Pointer var1);

        public Pointer lsl_get_info(Pointer var1);

        public int lsl_resolve_all(Pointer[] var1, long var2, double var4);

        public int lsl_resolve_byprop(Pointer[] var1, long var2, String var4, String var5, int var6, double var7);

        public int lsl_resolve_bypred(Pointer[] var1, long var2, String var4, int var5, double var6);

        public Pointer lsl_create_inlet(Pointer var1, int var2, int var3, int var4);

        public void lsl_destroy_inlet(Pointer var1);

        public Pointer lsl_get_fullinfo(Pointer var1, double var2, int[] var4);

        public void lsl_open_stream(Pointer var1, double var2, int[] var4);

        public void lsl_close_stream(Pointer var1);

        public double lsl_time_correction(Pointer var1, double var2, int[] var4);

        public double lsl_pull_sample_f(Pointer var1, float[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_d(Pointer var1, double[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_i(Pointer var1, int[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_s(Pointer var1, short[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_c(Pointer var1, byte[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_str(Pointer var1, String[] var2, int var3, double var4, int[] var6);

        public double lsl_pull_sample_buf(Pointer var1, byte[][] var2, long[] var3, int var4, double var5, int[] var7);

        public long lsl_pull_chunk_f(Pointer var1, float[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_d(Pointer var1, double[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_i(Pointer var1, int[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_s(Pointer var1, short[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_c(Pointer var1, byte[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_str(Pointer var1, String[] var2, double[] var3, long var4, long var6, double var8, int[] var10);

        public long lsl_pull_chunk_buf(Pointer var1, byte[][] var2, long[] var3, double[] var4, long var5, long var7, double var9, int[] var11);

        public int lsl_samples_available(Pointer var1);

        public int lsl_was_clock_reset(Pointer var1);

        public Pointer lsl_first_child(Pointer var1);

        public Pointer lsl_last_child(Pointer var1);

        public Pointer lsl_next_sibling(Pointer var1);

        public Pointer lsl_previous_sibling(Pointer var1);

        public Pointer lsl_parent(Pointer var1);

        public Pointer lsl_child(Pointer var1, String var2);

        public Pointer lsl_next_sibling_n(Pointer var1, String var2);

        public Pointer lsl_previous_sibling_n(Pointer var1, String var2);

        public int lsl_empty(Pointer var1);

        public int lsl_is_text(Pointer var1);

        public String lsl_name(Pointer var1);

        public String lsl_value(Pointer var1);

        public String lsl_child_value(Pointer var1);

        public String lsl_child_value_n(Pointer var1, String var2);

        public Pointer lsl_append_child_value(Pointer var1, String var2, String var3);

        public Pointer lsl_prepend_child_value(Pointer var1, String var2, String var3);

        public int lsl_set_child_value(Pointer var1, String var2, String var3);

        public int lsl_set_name(Pointer var1, String var2);

        public int lsl_set_value(Pointer var1, String var2);

        public Pointer lsl_append_child(Pointer var1, String var2);

        public Pointer lsl_prepend_child(Pointer var1, String var2);

        public Pointer lsl_append_copy(Pointer var1, Pointer var2);

        public Pointer lsl_prepend_copy(Pointer var1, Pointer var2);

        public void lsl_remove_child_n(Pointer var1, String var2);

        public void lsl_remove_child(Pointer var1, Pointer var2);

        public Pointer lsl_create_continuous_resolver(double var1);

        public Pointer lsl_create_continuous_resolver_byprop(String var1, String var2, double var3);

        public Pointer lsl_create_continuous_resolver_bypred(String var1, double var2);

        public int lsl_resolver_results(Pointer var1, Pointer[] var2, int var3);

        public void lsl_destroy_continuous_resolver(Pointer var1);
    }

    public static class InternalException
    extends Exception {
        public InternalException(String message) {
            super(message);
        }
    }

    public static class ArgumentException
    extends Exception {
        public ArgumentException(String message) {
            super(message);
        }
    }

    public static class LostException
    extends Exception {
        public LostException(String message) {
            super(message);
        }
    }

    public static class TimeoutException
    extends Exception {
        public TimeoutException(String message) {
            super(message);
        }
    }

    public static class ContinuousResolver {
        private Pointer obj;

        public ContinuousResolver(double forget_after) {
            this.obj = inst.lsl_create_continuous_resolver(forget_after);
        }

        public ContinuousResolver() {
            this.obj = inst.lsl_create_continuous_resolver(5.0);
        }

        public ContinuousResolver(String prop, String value, double forget_after) {
            this.obj = inst.lsl_create_continuous_resolver_byprop(prop, value, forget_after);
        }

        public ContinuousResolver(String prop, String value) {
            this.obj = inst.lsl_create_continuous_resolver_byprop(prop, value, 5.0);
        }

        public ContinuousResolver(String pred, double forget_after) {
            this.obj = inst.lsl_create_continuous_resolver_bypred(pred, forget_after);
        }

        public ContinuousResolver(String pred) {
            this.obj = inst.lsl_create_continuous_resolver_bypred(pred, 5.0);
        }

        void close() {
            inst.lsl_destroy_continuous_resolver(this.obj);
        }

        public StreamInfo[] results() {
            Pointer[] buf = new Pointer[1024];
            int num = inst.lsl_resolver_results(this.obj, buf, buf.length);
            StreamInfo[] res = new StreamInfo[num];
            for (int k = 0; k < num; ++k) {
                res[k] = new StreamInfo(buf[k]);
            }
            return res;
        }
    }

    public static class XMLElement {
        private Pointer obj;

        public XMLElement(Pointer handle) {
            this.obj = handle;
        }

        public XMLElement first_child() {
            return new XMLElement(inst.lsl_first_child(this.obj));
        }

        public XMLElement last_child() {
            return new XMLElement(inst.lsl_last_child(this.obj));
        }

        public XMLElement next_sibling() {
            return new XMLElement(inst.lsl_next_sibling(this.obj));
        }

        public XMLElement previous_sibling() {
            return new XMLElement(inst.lsl_previous_sibling(this.obj));
        }

        public XMLElement parent() {
            return new XMLElement(inst.lsl_parent(this.obj));
        }

        public XMLElement child(String name) {
            return new XMLElement(inst.lsl_child(this.obj, name));
        }

        public XMLElement next_sibling(String name) {
            return new XMLElement(inst.lsl_next_sibling_n(this.obj, name));
        }

        public XMLElement previous_sibling(String name) {
            return new XMLElement(inst.lsl_previous_sibling_n(this.obj, name));
        }

        public boolean empty() {
            return inst.lsl_empty(this.obj) != 0;
        }

        public boolean is_text() {
            return inst.lsl_is_text(this.obj) != 0;
        }

        public String name() {
            return inst.lsl_name(this.obj);
        }

        public String value() {
            return inst.lsl_value(this.obj);
        }

        public String child_value() {
            return inst.lsl_child_value(this.obj);
        }

        public String child_value(String name) {
            return inst.lsl_child_value_n(this.obj, name);
        }

        public XMLElement append_child_value(String name, String value) {
            return new XMLElement(inst.lsl_append_child_value(this.obj, name, value));
        }

        public XMLElement prepend_child_value(String name, String value) {
            return new XMLElement(inst.lsl_prepend_child_value(this.obj, name, value));
        }

        public boolean set_child_value(String name, String value) {
            return inst.lsl_set_child_value(this.obj, name, value) != 0;
        }

        public boolean set_name(String rhs) {
            return inst.lsl_set_name(this.obj, rhs) != 0;
        }

        public boolean set_value(String rhs) {
            return inst.lsl_set_value(this.obj, rhs) != 0;
        }

        public XMLElement append_child(String name) {
            return new XMLElement(inst.lsl_append_child(this.obj, name));
        }

        public XMLElement prepend_child(String name) {
            return new XMLElement(inst.lsl_prepend_child(this.obj, name));
        }

        public XMLElement append_copy(XMLElement e) {
            return new XMLElement(inst.lsl_append_copy(this.obj, e.obj));
        }

        public XMLElement prepend_copy(XMLElement e) {
            return new XMLElement(inst.lsl_prepend_copy(this.obj, e.obj));
        }

        public void remove_child(String name) {
            inst.lsl_remove_child_n(this.obj, name);
        }

        public void remove_child(XMLElement e) {
            inst.lsl_remove_child(this.obj, e.obj);
        }
    }

    public static class StreamInlet {
        private Pointer obj;

        public StreamInlet(StreamInfo info, int max_buflen, int max_chunklen, boolean recover) {
            this.obj = inst.lsl_create_inlet(info.handle(), max_buflen, max_chunklen, recover ? 1 : 0);
        }

        public StreamInlet(StreamInfo info, int max_buflen, int max_chunklen) {
            this.obj = inst.lsl_create_inlet(info.handle(), max_buflen, max_chunklen, 1);
        }

        public StreamInlet(StreamInfo info, int max_buflen) {
            this.obj = inst.lsl_create_inlet(info.handle(), max_buflen, 0, 1);
        }

        public StreamInlet(StreamInfo info) {
            this.obj = inst.lsl_create_inlet(info.handle(), 360, 0, 1);
        }

        public void close() {
            inst.lsl_destroy_inlet(this.obj);
        }

        public StreamInfo info(double timeout) throws Exception {
            int[] ec = new int[]{0};
            Pointer res = inst.lsl_get_fullinfo(this.obj, timeout, ec);
            LSL.check_error(ec);
            return new StreamInfo(res);
        }

        public StreamInfo info() throws Exception {
            return this.info(3.2E7);
        }

        public void open_stream(double timeout) throws Exception {
            int[] ec = new int[]{0};
            inst.lsl_open_stream(this.obj, timeout, ec);
            LSL.check_error(ec);
        }

        public void open_stream() throws Exception {
            this.open_stream(3.2E7);
        }

        public void close_stream() {
            inst.lsl_close_stream(this.obj);
        }

        public double time_correction(double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_time_correction(this.obj, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double time_correction() throws Exception {
            return this.time_correction(3.2E7);
        }

        public double pull_sample(float[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_f(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(float[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public double pull_sample(double[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_d(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(double[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public double pull_sample(int[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_i(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(int[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public double pull_sample(short[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_s(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(short[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public double pull_sample(byte[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_c(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(byte[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public double pull_sample(String[] sample, double timeout) throws Exception {
            int[] ec = new int[]{0};
            double res = inst.lsl_pull_sample_str(this.obj, sample, sample.length, timeout, ec);
            LSL.check_error(ec);
            return res;
        }

        public double pull_sample(String[] sample) throws Exception {
            return this.pull_sample(sample, 3.2E7);
        }

        public int pull_chunk(float[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_f(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(float[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int pull_chunk(double[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_d(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(double[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int pull_chunk(short[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_s(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(short[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int pull_chunk(byte[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_c(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(byte[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int pull_chunk(int[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_i(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(int[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int pull_chunk(String[] data_buffer, double[] timestamp_buffer, double timeout) throws Exception {
            int[] ec = new int[]{0};
            long res = inst.lsl_pull_chunk_str(this.obj, data_buffer, timestamp_buffer, data_buffer.length, timestamp_buffer.length, timeout, ec);
            LSL.check_error(ec);
            return (int)res;
        }

        public int pull_chunk(String[] data_buffer, double[] timestamp_buffer) throws Exception {
            return this.pull_chunk(data_buffer, timestamp_buffer, 0.0);
        }

        public int samples_available() {
            return inst.lsl_samples_available(this.obj);
        }

        public boolean was_clock_reset() {
            return inst.lsl_was_clock_reset(this.obj) != 0;
        }
    }

    public static class StreamOutlet {
        private Pointer obj;

        public StreamOutlet(StreamInfo info, int chunk_size, int max_buffered) {
            this.obj = inst.lsl_create_outlet(info.handle(), chunk_size, max_buffered);
        }

        public StreamOutlet(StreamInfo info, int chunk_size) {
            this.obj = inst.lsl_create_outlet(info.handle(), chunk_size, 360);
        }

        public StreamOutlet(StreamInfo info) {
            this.obj = inst.lsl_create_outlet(info.handle(), 0, 360);
        }

        public void close() {
            inst.lsl_destroy_outlet(this.obj);
        }

        public void push_sample(float[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_ftp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(float[] data, double timestamp) {
            inst.lsl_push_sample_ftp(this.obj, data, timestamp, 1);
        }

        public void push_sample(float[] data) {
            inst.lsl_push_sample_ftp(this.obj, data, 0.0, 1);
        }

        public void push_sample(double[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_dtp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(double[] data, double timestamp) {
            inst.lsl_push_sample_dtp(this.obj, data, timestamp, 1);
        }

        public void push_sample(double[] data) {
            inst.lsl_push_sample_dtp(this.obj, data, 0.0, 1);
        }

        public void push_sample(int[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_itp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(int[] data, double timestamp) {
            inst.lsl_push_sample_itp(this.obj, data, timestamp, 1);
        }

        public void push_sample(int[] data) {
            inst.lsl_push_sample_itp(this.obj, data, 0.0, 1);
        }

        public void push_sample(short[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_stp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(short[] data, double timestamp) {
            inst.lsl_push_sample_stp(this.obj, data, timestamp, 1);
        }

        public void push_sample(short[] data) {
            inst.lsl_push_sample_stp(this.obj, data, 0.0, 1);
        }

        public void push_sample(byte[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_ctp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(byte[] data, double timestamp) {
            inst.lsl_push_sample_ctp(this.obj, data, timestamp, 1);
        }

        public void push_sample(byte[] data) {
            inst.lsl_push_sample_ctp(this.obj, data, 0.0, 1);
        }

        public void push_sample(String[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_sample_strtp(this.obj, data, timestamp, pushthrough ? 1 : 0);
        }

        public void push_sample(String[] data, double timestamp) {
            inst.lsl_push_sample_strtp(this.obj, data, timestamp, 1);
        }

        public void push_sample(String[] data) {
            inst.lsl_push_sample_strtp(this.obj, data, 0.0, 1);
        }

        public void push_chunk(float[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_ftp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(float[] data, double timestamp) {
            inst.lsl_push_chunk_ftp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(float[] data) {
            inst.lsl_push_chunk_ftp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(double[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_dtp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(double[] data, double timestamp) {
            inst.lsl_push_chunk_dtp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(double[] data) {
            inst.lsl_push_chunk_dtp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(int[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_itp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(int[] data, double timestamp) {
            inst.lsl_push_chunk_itp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(int[] data) {
            inst.lsl_push_chunk_itp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(short[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_stp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(short[] data, double timestamp) {
            inst.lsl_push_chunk_stp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(short[] data) {
            inst.lsl_push_chunk_stp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(byte[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_ctp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(byte[] data, double timestamp) {
            inst.lsl_push_chunk_ctp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(byte[] data) {
            inst.lsl_push_chunk_ctp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(String[] data, double timestamp, boolean pushthrough) {
            inst.lsl_push_chunk_strtp(this.obj, data, data.length, timestamp, pushthrough ? 1 : 0);
        }

        public void push_chunk(String[] data, double timestamp) {
            inst.lsl_push_chunk_strtp(this.obj, data, data.length, timestamp, 1);
        }

        public void push_chunk(String[] data) {
            inst.lsl_push_chunk_strtp(this.obj, data, data.length, 0.0, 1);
        }

        public void push_chunk(float[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_ftnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(float[] data, double[] timestamps) {
            inst.lsl_push_chunk_ftnp(this.obj, data, data.length, timestamps, 1);
        }

        public void push_chunk(double[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_dtnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(double[] data, double[] timestamps) {
            inst.lsl_push_chunk_dtnp(this.obj, data, data.length, timestamps, 1);
        }

        public void push_chunk(int[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_itnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(int[] data, double[] timestamps) {
            inst.lsl_push_chunk_itnp(this.obj, data, data.length, timestamps, 1);
        }

        public void push_chunk(short[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_stnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(short[] data, double[] timestamps) {
            inst.lsl_push_chunk_stnp(this.obj, data, data.length, timestamps, 1);
        }

        public void push_chunk(byte[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_ctnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(byte[] data, double[] timestamps) {
            inst.lsl_push_chunk_ctnp(this.obj, data, data.length, timestamps, 1);
        }

        public void push_chunk(String[] data, double[] timestamps, boolean pushthrough) {
            inst.lsl_push_chunk_strtnp(this.obj, data, data.length, timestamps, pushthrough ? 1 : 0);
        }

        public void push_chunk(String[] data, double[] timestamps) {
            inst.lsl_push_chunk_strtnp(this.obj, data, data.length, timestamps, 1);
        }

        public boolean have_consumers() {
            return inst.lsl_have_consumers(this.obj) > 0;
        }

        public boolean wait_for_consumers(double timeout) {
            return inst.lsl_wait_for_consumers(this.obj) > 0;
        }

        public StreamInfo info() {
            return new StreamInfo(inst.lsl_get_info(this.obj));
        }
    }

    public static class StreamInfo {
        private Pointer obj;

        public StreamInfo(String name, String type, int channel_count, double nominal_srate, int channel_format, String source_id) {
            this.obj = inst.lsl_create_streaminfo(name, type, channel_count, nominal_srate, channel_format, source_id);
        }

        public StreamInfo(String name, String type, int channel_count, double nominal_srate, int channel_format) {
            this.obj = inst.lsl_create_streaminfo(name, type, channel_count, nominal_srate, channel_format, "");
        }

        public StreamInfo(String name, String type, int channel_count, double nominal_srate) {
            this.obj = inst.lsl_create_streaminfo(name, type, channel_count, nominal_srate, 1, "");
        }

        public StreamInfo(String name, String type, int channel_count) {
            this.obj = inst.lsl_create_streaminfo(name, type, channel_count, 0.0, 1, "");
        }

        public StreamInfo(String name, String type) {
            this.obj = inst.lsl_create_streaminfo(name, type, 1, 0.0, 1, "");
        }

        public StreamInfo(Pointer handle) {
            this.obj = handle;
        }

        public void destroy() {
            inst.lsl_destroy_streaminfo(this.obj);
        }

        public String name() {
            return inst.lsl_get_name(this.obj);
        }

        public String type() {
            return inst.lsl_get_type(this.obj);
        }

        public int channel_count() {
            return inst.lsl_get_channel_count(this.obj);
        }

        public double nominal_srate() {
            return inst.lsl_get_nominal_srate(this.obj);
        }

        public int channel_format() {
            return inst.lsl_get_channel_format(this.obj);
        }

        public String source_id() {
            return inst.lsl_get_source_id(this.obj);
        }

        public int version() {
            return inst.lsl_get_version(this.obj);
        }

        public double created_at() {
            return inst.lsl_get_created_at(this.obj);
        }

        public String uid() {
            return inst.lsl_get_uid(this.obj);
        }

        public String session_id() {
            return inst.lsl_get_session_id(this.obj);
        }

        public String hostname() {
            return inst.lsl_get_hostname(this.obj);
        }

        public XMLElement desc() {
            return new XMLElement(inst.lsl_get_desc(this.obj));
        }

        public String as_xml() {
            return inst.lsl_get_xml(this.obj);
        }

        public Pointer handle() {
            return this.obj;
        }
    }

    public class ChannelFormat {
        public static final int float32 = 1;
        public static final int double64 = 2;
        public static final int string = 3;
        public static final int int32 = 4;
        public static final int int16 = 5;
        public static final int int8 = 6;
        public static final int int64 = 7;
        public static final int undefined = 0;
    }
}

