/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSource;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecordingStream;

public class AudioPlayer
extends AudioSource
implements Playable {
    private AudioRecordingStream recording;
    private AudioOut output;
    private boolean isPaused;

    public AudioPlayer(AudioRecordingStream recording, AudioOut out) {
        super(out);
        this.recording = recording;
        this.output = out;
        this.output.setAudioStream(recording);
    }

    @Override
    public void play() {
        this.recording.play();
        this.isPaused = false;
    }

    @Override
    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    @Override
    public void pause() {
        this.recording.pause();
        this.isPaused = true;
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop(int num) {
        if (this.isPaused) {
            int pos = this.recording.getMillisecondPosition();
            this.recording.loop(num);
            this.recording.setMillisecondPosition(pos);
        } else {
            this.recording.loop(num);
        }
        this.isPaused = false;
    }

    @Override
    public void loop() {
        this.loop(-1);
    }

    @Override
    public int loopCount() {
        return this.recording.getLoopCount();
    }

    @Override
    public int length() {
        return this.recording.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.recording.getMillisecondPosition();
    }

    @Override
    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.recording.setMillisecondPosition(millis);
    }

    @Override
    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + millis + " milliseconds, new position is " + pos);
        this.recording.setMillisecondPosition(pos);
    }

    @Override
    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    @Override
    public void setLoopPoints(int start, int stop) {
        this.recording.setLoopPoints(start, stop);
    }

    @Override
    public void close() {
        this.recording.close();
        super.close();
    }
}

