/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Wavetable;
import ddf.minim.ugens.WavetableGenerator;

public class Waves {
    private static int tableSize = 8192;
    private static int tSby2 = tableSize / 2;
    private static int tSby4 = tableSize / 4;
    public static final Wavetable SINE = WavetableGenerator.gen10(tableSize, new float[]{1.0f});
    public static final Wavetable SAW = WavetableGenerator.gen7(tableSize, new float[]{0.0f, -1.0f, 1.0f, 0.0f}, new int[]{tSby2, 0, tableSize - tSby2});
    public static final Wavetable PHASOR = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f}, new int[]{tableSize});
    public static final Wavetable SQUARE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, new int[]{tSby2, 0, tableSize - tSby2});
    public static final Wavetable TRIANGLE = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f, -1.0f, 0.0f}, new int[]{tSby4, tSby2, tableSize - tSby2 - tSby4});
    public static final Wavetable QUARTERPULSE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, new int[]{tSby4, 0, tableSize - tSby4});

    private Waves() {
    }

    public static Wavetable sawh(int numberOfHarmonics) {
        float[] content = new float[numberOfHarmonics];
        for (int i = 0; i < numberOfHarmonics; ++i) {
            content[i] = (float)(-2.0 / ((double)(i + 1) * Math.PI) * Math.pow(-1.0, i + 1));
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable saw(float dutyCycle) {
        dutyCycle = Math.max(0.0f, Math.min(dutyCycle, 1.0f));
        int a = (int)((float)tableSize * dutyCycle);
        return WavetableGenerator.gen7(tableSize, new float[]{0.0f, -1.0f, 1.0f, 0.0f}, new int[]{a, 0, tableSize - a});
    }

    public static Wavetable squareh(int numberOfHarmonics) {
        float[] content = new float[numberOfHarmonics + 1];
        for (int i = 0; i < numberOfHarmonics; i += 2) {
            content[i] = 1.0f / (float)(i + 1);
            content[i + 1] = 0.0f;
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable square(float dutyCycle) {
        return Waves.pulse(dutyCycle);
    }

    public static Wavetable pulse(float dutyCycle) {
        dutyCycle = Math.max(0.0f, Math.min(dutyCycle, 1.0f));
        return WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, new int[]{(int)(dutyCycle * (float)tableSize), 0, tableSize - (int)(dutyCycle * (float)tableSize)});
    }

    public static Wavetable triangleh(int numberOfHarmonics) {
        float[] content = new float[numberOfHarmonics + 1];
        for (int i = 0; i < numberOfHarmonics; i += 2) {
            content[i] = (float)(Math.pow(-1.0, i / 2) * 8.0 / Math.PI / Math.PI / Math.pow(i + 1, 2.0));
            content[i + 1] = 0.0f;
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable triangle(float dutyCycle) {
        dutyCycle = Math.max(0.0f, Math.min(dutyCycle, 1.0f));
        int a = (int)((double)((float)tableSize * dutyCycle) * 0.5);
        return WavetableGenerator.gen7(tableSize, new float[]{0.0f, -1.0f, 0.0f, 1.0f, 0.0f}, new int[]{a, a, tSby2 - a, tableSize - tSby2 - a});
    }

    public static Wavetable randomNHarms(int numberOfHarmonics) {
        float[] harmAmps = new float[numberOfHarmonics];
        for (int i = 0; i < numberOfHarmonics; ++i) {
            harmAmps[i] = (float)Math.random() * 2.0f - 1.0f;
        }
        Wavetable builtWave = WavetableGenerator.gen10(tableSize, harmAmps);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable randomNOddHarms(int numberOfHarmonics) {
        float[] harmAmps = new float[numberOfHarmonics * 2];
        for (int i = 0; i < numberOfHarmonics; ++i) {
            harmAmps[i * 2] = (float)Math.random() * 2.0f - 1.0f;
            harmAmps[i * 2 + 1] = 0.0f;
        }
        Wavetable builtWave = WavetableGenerator.gen10(tableSize, harmAmps);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable randomNoise() {
        float[] builtArray = new float[tableSize];
        for (int i = 0; i < builtArray.length; ++i) {
            builtArray[i] = (float)Math.random() * 2.0f - 1.0f;
        }
        Wavetable builtWave = new Wavetable(builtArray);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable add(float[] amps, Waveform ... waves) {
        if (amps.length != waves.length) {
            System.out.println("add() : amplitude array size must match the number of waveforms!");
            return null;
        }
        float[] accumulate = new float[tableSize];
        for (int i = 0; i < waves.length; ++i) {
            int j = 0;
            while (j < tableSize) {
                float lu = (float)j / (float)tableSize;
                int n = j++;
                accumulate[n] = accumulate[n] + waves[i].value(lu) * amps[i];
            }
        }
        return new Wavetable(accumulate);
    }
}

