/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.ControllerGroup;
import processing.core.PGraphics;

public class Tab
extends ControllerGroup<Tab> {
    protected int _myOffsetX = -1000;
    protected int _myOffsetY = -1000;
    protected boolean isActive = false;
    private boolean isAlwaysActive = false;
    protected boolean isEventActive = false;
    protected float _myValue = 0.0f;
    protected String _myStringValue = "";
    public static int padding = 4;
    public boolean autoWidth = true;

    public Tab(ControlP5 controlP5, ControlWindow controlWindow, String string) {
        super(controlP5, null, string, 0.0f, 0.0f);
        this.position = new float[2];
        this.absolutePosition = new float[2];
        this.isMoveable = false;
        this.isEventActive = controlP5.isTabEventsActive;
        this._myHeight = 16;
        this._myWidth = this._myLabel.getWidth() + padding * 2;
        this._myLabel.align(37, 3).setPadding(0, 0);
    }

    protected void setOffset(int n, int n2) {
        this._myOffsetX = n;
        this._myOffsetY = n2;
    }

    protected int height() {
        return this._myHeight;
    }

    protected boolean updateLabel() {
        this.isInside = this.inside();
        return this.cp5.getWindow().getTabs().size() > 2;
    }

    protected void drawLabel(PGraphics pGraphics) {
        if (this.autoWidth) {
            this._myWidth = this._myLabel.getWidth() + padding * 2;
        }
        pGraphics.pushMatrix();
        pGraphics.pushStyle();
        pGraphics.noStroke();
        pGraphics.fill(this.isInside ? this.color.getForeground() : this.color.getBackground());
        if (this.isActive) {
            pGraphics.fill(this.color.getActive());
        }
        pGraphics.translate((float)this._myOffsetX, (float)this._myOffsetY);
        pGraphics.rect(0.0f, 0.0f, (float)(this._myWidth - 1), (float)this._myHeight);
        this._myLabel.draw(pGraphics, padding, 0, this);
        pGraphics.popStyle();
        pGraphics.popMatrix();
    }

    @Override
    public Tab setLabel(String string) {
        this._myLabel.set(string);
        return this;
    }

    protected int width() {
        return this._myWidth;
    }

    @Override
    public Tab setWidth(int n) {
        this._myWidth = n + padding;
        this.autoWidth = false;
        return this;
    }

    @Override
    public Tab setHeight(int n) {
        this._myHeight = n;
        return this;
    }

    @Override
    protected boolean inside() {
        return this.cp5.getWindow().mouseX > this._myOffsetX && this.cp5.getWindow().mouseX < this._myOffsetX + this._myWidth && this.cp5.getWindow().mouseY > this._myOffsetY && this.cp5.getWindow().mouseY < this._myOffsetY + this._myHeight;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.cp5.getWindow().activateTab(this);
        if (this.isEventActive) {
            this.cp5.getControlBroadcaster().broadcast(new ControlEvent(this), 0);
        }
    }

    public Tab setActive(boolean bl) {
        this.isActive = bl;
        return this;
    }

    public Tab setAlwaysActive(boolean bl) {
        this.isAlwaysActive = bl;
        return this;
    }

    public boolean isActive() {
        return this.isAlwaysActive ? true : this.isActive;
    }

    public boolean isAlwaysActive() {
        return this.isAlwaysActive;
    }

    @Override
    public Tab bringToFront() {
        this.cp5.getWindow().activateTab(this);
        return this;
    }

    @Override
    public Tab moveTo(ControlWindow controlWindow) {
        this.cp5.getWindow().removeTab(this);
        this.setTab(controlWindow, this.getName());
        return this;
    }

    public Tab activateEvent(boolean bl) {
        this.isEventActive = bl;
        return this;
    }

    @Override
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    public float getValue() {
        return this._myValue;
    }

    @Override
    public Tab setValue(float f) {
        this._myValue = f;
        return this;
    }

    @Deprecated
    public float value() {
        return this._myValue;
    }

    @Deprecated
    public String stringValue() {
        return this._myStringValue;
    }
}

