/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public class GAxisLabel
implements PConstants {
    protected final PApplet parent;
    protected final int type;
    protected float[] dim;
    protected float relativePos;
    protected float plotPos;
    protected float offset;
    protected boolean rotate;
    protected String text;
    protected int textAlignment;
    protected String fontName;
    protected int fontColor;
    protected int fontSize;
    protected PFont font;

    public GAxisLabel(PApplet pApplet, int n, float[] fArray) {
        this.parent = pApplet;
        this.type = n == 0 || n == 1 || n == 101 || n == 39 ? n : 0;
        this.dim = (float[])fArray.clone();
        this.relativePos = 0.5f;
        this.plotPos = this.type == 0 || this.type == 101 ? this.relativePos * this.dim[0] : -this.relativePos * this.dim[1];
        this.offset = 35.0f;
        this.rotate = this.type != 0 && this.type != 101;
        this.text = "";
        this.textAlignment = 3;
        this.fontName = "SansSerif.plain";
        this.fontColor = this.parent.color(0);
        this.fontSize = 13;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void draw() {
        switch (this.type) {
            case 0: {
                this.drawAsXLabel();
                break;
            }
            case 1: {
                this.drawAsYLabel();
                break;
            }
            case 101: {
                this.drawAsTopLabel();
                break;
            }
            case 39: {
                this.drawAsRightLabel();
            }
        }
    }

    protected void drawAsXLabel() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        if (this.rotate) {
            this.parent.textAlign(39, 3);
            this.parent.pushMatrix();
            this.parent.translate(this.plotPos, this.offset);
            this.parent.rotate(-1.5707964f);
            this.parent.text(this.text, 0.0f, 0.0f);
            this.parent.popMatrix();
        } else {
            this.parent.textAlign(this.textAlignment, 101);
            this.parent.text(this.text, this.plotPos, this.offset);
        }
        this.parent.popStyle();
    }

    protected void drawAsYLabel() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        if (this.rotate) {
            this.parent.textAlign(this.textAlignment, 102);
            this.parent.pushMatrix();
            this.parent.translate(-this.offset, this.plotPos);
            this.parent.rotate(-1.5707964f);
            this.parent.text(this.text, 0.0f, 0.0f);
            this.parent.popMatrix();
        } else {
            this.parent.textAlign(39, 3);
            this.parent.text(this.text, -this.offset, this.plotPos);
        }
        this.parent.popStyle();
    }

    protected void drawAsTopLabel() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        if (this.rotate) {
            this.parent.textAlign(37, 3);
            this.parent.pushMatrix();
            this.parent.translate(this.plotPos, -this.offset - this.dim[1]);
            this.parent.rotate(-1.5707964f);
            this.parent.text(this.text, 0.0f, 0.0f);
            this.parent.popMatrix();
        } else {
            this.parent.textAlign(this.textAlignment, 102);
            this.parent.text(this.text, this.plotPos, -this.offset - this.dim[1]);
        }
        this.parent.popStyle();
    }

    protected void drawAsRightLabel() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        if (this.rotate) {
            this.parent.textAlign(this.textAlignment, 101);
            this.parent.pushMatrix();
            this.parent.translate(this.offset + this.dim[0], this.plotPos);
            this.parent.rotate(-1.5707964f);
            this.parent.text(this.text, 0.0f, 0.0f);
            this.parent.popMatrix();
        } else {
            this.parent.textAlign(37, 3);
            this.parent.text(this.text, this.offset + this.dim[0], this.plotPos);
        }
        this.parent.popStyle();
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            this.dim[0] = f;
            this.dim[1] = f2;
            this.plotPos = this.type == 0 || this.type == 101 ? this.relativePos * this.dim[0] : -this.relativePos * this.dim[1];
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setRelativePos(float f) {
        this.relativePos = f;
        this.plotPos = this.type == 0 || this.type == 101 ? this.relativePos * this.dim[0] : -this.relativePos * this.dim[1];
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public void setRotate(boolean bl) {
        this.rotate = bl;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTextAlignment(int n) {
        if (n == 3 || n == 37 || n == 39) {
            this.textAlignment = n;
        }
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public void setFontSize(int n) {
        if (n > 0) {
            this.fontSize = n;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setFontProperties(String string, int n, int n2) {
        if (n2 > 0) {
            this.fontName = string;
            this.fontColor = n;
            this.fontSize = n2;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }
}

