/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import grafica.GPoint;
import grafica.GPointsArray;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public class GHistogram
implements PConstants {
    protected final PApplet parent;
    protected int type;
    protected float[] dim;
    protected GPointsArray plotPoints;
    protected boolean visible;
    protected float[] separations;
    protected int[] bgColors;
    protected int[] lineColors;
    protected float[] lineWidths;
    protected ArrayList<Float> differences;
    protected ArrayList<Float> leftSides;
    protected ArrayList<Float> rightSides;
    protected float labelsOffset;
    protected boolean drawLabels;
    protected boolean rotateLabels;
    protected String fontName;
    protected int fontColor;
    protected int fontSize;
    protected PFont font;

    public GHistogram(PApplet pApplet, int n, float[] fArray, GPointsArray gPointsArray) {
        this.parent = pApplet;
        this.type = n == 0 || n == 1 ? n : 0;
        this.dim = (float[])fArray.clone();
        this.plotPoints = new GPointsArray(gPointsArray);
        this.visible = true;
        this.separations = new float[]{2.0f};
        this.bgColors = new int[]{this.parent.color(150, 150, 255)};
        this.lineColors = new int[]{this.parent.color(100, 100, 255)};
        this.lineWidths = new float[]{1.0f};
        int n2 = gPointsArray.getNPoints();
        this.differences = new ArrayList(n2);
        this.leftSides = new ArrayList(n2);
        this.rightSides = new ArrayList(n2);
        this.initializeArrays(n2);
        this.updateArrays();
        this.labelsOffset = 8.0f;
        this.drawLabels = false;
        this.rotateLabels = false;
        this.fontName = "SansSerif.plain";
        this.fontColor = this.parent.color(0);
        this.fontSize = 11;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    protected void initializeArrays(int n) {
        if (this.differences.size() < n) {
            for (int i = this.differences.size(); i < n; ++i) {
                this.differences.add(Float.valueOf(0.0f));
                this.leftSides.add(Float.valueOf(0.0f));
                this.rightSides.add(Float.valueOf(0.0f));
            }
        } else {
            this.differences.subList(n, this.differences.size()).clear();
        }
    }

    protected void updateArrays() {
        int n = this.plotPoints.getNPoints();
        if (n == 1) {
            this.leftSides.set(0, Float.valueOf(this.type == 0 ? 0.2f * this.dim[0] : 0.2f * this.dim[1]));
            this.rightSides.set(0, this.leftSides.get(0));
        } else if (n > 1) {
            int n2;
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (this.plotPoints.isValid(n2) && this.plotPoints.isValid(n2 + 1)) {
                    float f = this.separations[n2 % this.separations.length];
                    float f2 = this.type == 0 ? this.plotPoints.getX(n2 + 1) - this.plotPoints.getX(n2) : this.plotPoints.getY(n2 + 1) - this.plotPoints.getY(n2);
                    if (f2 > 0.0f) {
                        this.differences.set(n2, Float.valueOf((f2 - f) / 2.0f));
                        continue;
                    }
                    this.differences.set(n2, Float.valueOf((f2 + f) / 2.0f));
                    continue;
                }
                this.differences.set(n2, Float.valueOf(0.0f));
            }
            this.leftSides.set(0, this.differences.get(0));
            this.rightSides.set(0, this.differences.get(0));
            for (n2 = 1; n2 < n - 1; ++n2) {
                this.leftSides.set(n2, this.differences.get(n2 - 1));
                this.rightSides.set(n2, this.differences.get(n2));
            }
            this.leftSides.set(n - 1, this.differences.get(n - 2));
            this.rightSides.set(n - 1, this.differences.get(n - 2));
        }
    }

    public void draw(GPoint gPoint) {
        if (this.visible) {
            float f = 0.0f;
            if (gPoint.isValid()) {
                f = this.type == 0 ? gPoint.getY() : gPoint.getX();
            }
            this.parent.pushStyle();
            this.parent.rectMode(1);
            this.parent.strokeCap(1);
            for (int i = 0; i < this.plotPoints.getNPoints(); ++i) {
                float f2;
                float f3;
                float f4;
                float f5;
                if (!this.plotPoints.isValid(i)) continue;
                if (this.type == 0) {
                    f5 = this.plotPoints.getX(i) - this.leftSides.get(i).floatValue();
                    f4 = this.plotPoints.getX(i) + this.rightSides.get(i).floatValue();
                    f3 = this.plotPoints.getY(i);
                    f2 = f;
                } else {
                    f5 = f;
                    f4 = this.plotPoints.getX(i);
                    f3 = this.plotPoints.getY(i) - this.leftSides.get(i).floatValue();
                    f2 = this.plotPoints.getY(i) + this.rightSides.get(i).floatValue();
                }
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                } else if (f5 > this.dim[0]) {
                    f5 = this.dim[0];
                }
                if (-f3 < 0.0f) {
                    f3 = 0.0f;
                } else if (-f3 > this.dim[1]) {
                    f3 = -this.dim[1];
                }
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                } else if (f4 > this.dim[0]) {
                    f4 = this.dim[0];
                }
                if (-f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (-f2 > this.dim[1]) {
                    f2 = -this.dim[1];
                }
                float f6 = this.lineWidths[i % this.lineWidths.length];
                this.parent.fill(this.bgColors[i % this.bgColors.length]);
                this.parent.stroke(this.lineColors[i % this.lineColors.length]);
                this.parent.strokeWeight(f6);
                if (Math.abs(f4 - f5) > 2.0f * f6 && Math.abs(f2 - f3) > 2.0f * f6) {
                    this.parent.rect(f5, f3, f4, f2);
                    continue;
                }
                if ((this.type != 0 || f4 == f5 || f3 == f2 && (f3 == 0.0f || f3 == -this.dim[1])) && (this.type != 1 || f2 == f3 || f5 == f4 && (f5 == 0.0f || f5 == this.dim[0]))) continue;
                this.parent.rect(f5, f3, f4, f2);
                this.parent.line(f5, f3, f5, f2);
                this.parent.line(f4, f3, f4, f2);
                this.parent.line(f5, f3, f4, f3);
                this.parent.line(f5, f2, f4, f2);
            }
            this.parent.popStyle();
            if (this.drawLabels) {
                this.drawHistLabels();
            }
        }
    }

    protected void drawHistLabels() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        if (this.type == 0) {
            if (this.rotateLabels) {
                this.parent.textAlign(39, 3);
                for (int i = 0; i < this.plotPoints.getNPoints(); ++i) {
                    if (!this.plotPoints.isValid(i) || !(this.plotPoints.getX(i) >= 0.0f) || !(this.plotPoints.getX(i) <= this.dim[0])) continue;
                    this.parent.pushMatrix();
                    this.parent.translate(this.plotPoints.getX(i), this.labelsOffset);
                    this.parent.rotate(-1.5707964f);
                    this.parent.text(this.plotPoints.getLabel(i), 0.0f, 0.0f);
                    this.parent.popMatrix();
                }
            } else {
                this.parent.textAlign(3, 101);
                for (int i = 0; i < this.plotPoints.getNPoints(); ++i) {
                    if (!this.plotPoints.isValid(i) || !(this.plotPoints.getX(i) >= 0.0f) || !(this.plotPoints.getX(i) <= this.dim[0])) continue;
                    this.parent.text(this.plotPoints.getLabel(i), this.plotPoints.getX(i), this.labelsOffset);
                }
            }
        } else if (this.rotateLabels) {
            this.parent.textAlign(3, 102);
            for (int i = 0; i < this.plotPoints.getNPoints(); ++i) {
                if (!this.plotPoints.isValid(i) || !(-this.plotPoints.getY(i) >= 0.0f) || !(-this.plotPoints.getY(i) <= this.dim[1])) continue;
                this.parent.pushMatrix();
                this.parent.translate(-this.labelsOffset, this.plotPoints.getY(i));
                this.parent.rotate(-1.5707964f);
                this.parent.text(this.plotPoints.getLabel(i), 0.0f, 0.0f);
                this.parent.popMatrix();
            }
        } else {
            this.parent.textAlign(39, 3);
            for (int i = 0; i < this.plotPoints.getNPoints(); ++i) {
                if (!this.plotPoints.isValid(i) || !(-this.plotPoints.getY(i) >= 0.0f) || !(-this.plotPoints.getY(i) <= this.dim[1])) continue;
                this.parent.text(this.plotPoints.getLabel(i), -this.labelsOffset, this.plotPoints.getY(i));
            }
        }
        this.parent.popStyle();
    }

    public void setType(int n) {
        if (n != this.type && (n == 0 || n == 1)) {
            this.type = n;
            this.updateArrays();
        }
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            this.dim[0] = f;
            this.dim[1] = f2;
            this.updateArrays();
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setPlotPoints(GPointsArray gPointsArray) {
        this.plotPoints.set(gPointsArray);
        this.initializeArrays(this.plotPoints.getNPoints());
        this.updateArrays();
    }

    public void setPlotPoint(int n, GPoint gPoint) {
        this.plotPoints.set(n, gPoint);
        this.updateArrays();
    }

    public void addPlotPoint(GPoint gPoint) {
        this.plotPoints.add(gPoint);
        this.initializeArrays(this.plotPoints.getNPoints());
        this.updateArrays();
    }

    public void addPlotPoint(int n, GPoint gPoint) {
        this.plotPoints.add(n, gPoint);
        this.initializeArrays(this.plotPoints.getNPoints());
        this.updateArrays();
    }

    public void addPlotPoints(GPointsArray gPointsArray) {
        this.plotPoints.add(gPointsArray);
        this.initializeArrays(this.plotPoints.getNPoints());
        this.updateArrays();
    }

    public void removePlotPoint(int n) {
        this.plotPoints.remove(n);
        this.initializeArrays(this.plotPoints.getNPoints());
        this.updateArrays();
    }

    public void setSeparations(float[] fArray) {
        this.separations = (float[])fArray.clone();
        this.updateArrays();
    }

    public void setBgColors(int[] nArray) {
        this.bgColors = (int[])nArray.clone();
    }

    public void setLineColors(int[] nArray) {
        this.lineColors = (int[])nArray.clone();
    }

    public void setLineWidths(float[] fArray) {
        this.lineWidths = (float[])fArray.clone();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setLabelsOffset(float f) {
        this.labelsOffset = f;
    }

    public void setDrawLabels(boolean bl) {
        this.drawLabels = bl;
    }

    public void setRotateLabels(boolean bl) {
        this.rotateLabels = bl;
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public void setFontSize(int n) {
        if (n > 0) {
            this.fontSize = n;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setFontProperties(String string, int n, int n2) {
        if (n2 > 0) {
            this.fontName = string;
            this.fontColor = n;
            this.fontSize = n2;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }
}

