/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import grafica.GAxis;
import grafica.GHistogram;
import grafica.GLayer;
import grafica.GPoint;
import grafica.GPointsArray;
import grafica.GTitle;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import processing.core.PShape;
import processing.event.MouseEvent;

public class GPlot
implements PConstants {
    protected final PApplet parent;
    protected float[] pos;
    protected float[] outerDim;
    protected float[] mar;
    protected float[] dim;
    protected float[] xLim;
    protected float[] yLim;
    protected boolean fixedXLim;
    protected boolean fixedYLim;
    protected boolean xLog;
    protected boolean yLog;
    protected boolean invertedXScale;
    protected boolean invertedYScale;
    protected boolean includeAllLayersInLim;
    protected float expandLimFactor;
    protected int bgColor;
    protected int boxBgColor;
    protected int boxLineColor;
    protected float boxLineWidth;
    protected int gridLineColor;
    protected float gridLineWidth;
    protected final GLayer mainLayer;
    protected final ArrayList<GLayer> layerList;
    protected final GAxis xAxis;
    protected final GAxis topAxis;
    protected final GAxis yAxis;
    protected final GAxis rightAxis;
    protected final GTitle title;
    public static final String MAINLAYERID = "main layer";
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int BOTH = 2;
    public static final int NONE = 0;
    public static final int ALTMOD = 8;
    public static final int CTRLMOD = 2;
    public static final int METAMOD = 4;
    public static final int SHIFTMOD = 1;
    public static final float LOG10 = (float)Math.log(10.0);
    protected boolean zoomingIsActive;
    protected float zoomFactor;
    protected int increaseZoomButton;
    protected int decreaseZoomButton;
    protected int increaseZoomKeyModifier;
    protected int decreaseZoomKeyModifier;
    protected boolean centeringIsActive;
    protected int centeringButton;
    protected int centeringKeyModifier;
    protected boolean panningIsActive;
    protected int panningButton;
    protected int panningKeyModifier;
    protected float[] panningReferencePoint;
    protected boolean labelingIsActive;
    protected int labelingButton;
    protected int labelingKeyModifier;
    protected float[] mousePos;
    protected boolean resetIsActive;
    protected int resetButton;
    protected int resetKeyModifier;
    protected float[] xLimReset;
    protected float[] yLimReset;

    public GPlot(PApplet pApplet, float f, float f2, float f3, float f4) {
        this.parent = pApplet;
        this.pos = new float[]{f, f2};
        this.outerDim = new float[]{f3, f4};
        this.mar = new float[]{60.0f, 70.0f, 40.0f, 30.0f};
        this.dim = new float[]{this.outerDim[0] - this.mar[1] - this.mar[3], this.outerDim[1] - this.mar[0] - this.mar[2]};
        this.xLim = new float[]{0.0f, 1.0f};
        this.yLim = new float[]{0.0f, 1.0f};
        this.fixedXLim = false;
        this.fixedYLim = false;
        this.xLog = false;
        this.yLog = false;
        this.invertedXScale = false;
        this.invertedYScale = false;
        this.includeAllLayersInLim = true;
        this.expandLimFactor = 0.1f;
        this.bgColor = this.parent.color(255);
        this.boxBgColor = this.parent.color(245);
        this.boxLineColor = this.parent.color(210);
        this.boxLineWidth = 1.0f;
        this.gridLineColor = this.parent.color(210);
        this.gridLineWidth = 1.0f;
        this.mainLayer = new GLayer(this.parent, MAINLAYERID, this.dim, this.xLim, this.yLim, this.xLog, this.yLog);
        this.layerList = new ArrayList();
        this.xAxis = new GAxis(this.parent, 0, this.dim, this.xLim, this.xLog);
        this.topAxis = new GAxis(this.parent, 101, this.dim, this.xLim, this.xLog);
        this.yAxis = new GAxis(this.parent, 1, this.dim, this.yLim, this.yLog);
        this.rightAxis = new GAxis(this.parent, 39, this.dim, this.yLim, this.yLog);
        this.title = new GTitle(this.parent, this.dim);
        this.parent.registerMethod("mouseEvent", (Object)this);
        this.zoomingIsActive = false;
        this.zoomFactor = 1.3f;
        this.increaseZoomButton = 37;
        this.decreaseZoomButton = 39;
        this.increaseZoomKeyModifier = 0;
        this.decreaseZoomKeyModifier = 0;
        this.centeringIsActive = false;
        this.centeringButton = 37;
        this.centeringKeyModifier = 0;
        this.panningIsActive = false;
        this.panningButton = 37;
        this.panningKeyModifier = 0;
        this.panningReferencePoint = null;
        this.labelingIsActive = false;
        this.labelingButton = 37;
        this.labelingKeyModifier = 0;
        this.mousePos = null;
        this.resetIsActive = false;
        this.resetButton = 39;
        this.resetKeyModifier = 2;
        this.xLimReset = null;
        this.yLimReset = null;
    }

    public GPlot(PApplet pApplet, float f, float f2) {
        this(pApplet, f, f2, 450.0f, 300.0f);
    }

    public GPlot(PApplet pApplet) {
        this(pApplet, 0.0f, 0.0f, 450.0f, 300.0f);
    }

    public void addLayer(GLayer gLayer) {
        String string = gLayer.getId();
        boolean bl = false;
        if (this.mainLayer.isId(string)) {
            bl = true;
        } else {
            for (int i = 0; i < this.layerList.size(); ++i) {
                if (!this.layerList.get(i).isId(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            gLayer.setDim(this.dim);
            gLayer.setLimAndLog(this.xLim, this.yLim, this.xLog, this.yLog);
            this.layerList.add(gLayer);
            if (this.includeAllLayersInLim) {
                this.updateLimits();
            }
        } else {
            PApplet.println((String)"A layer with the same id exists. Please change the id and try to add it again.");
        }
    }

    public void addLayer(String string, GPointsArray gPointsArray) {
        boolean bl = false;
        if (this.mainLayer.isId(string)) {
            bl = true;
        } else {
            for (int i = 0; i < this.layerList.size(); ++i) {
                if (!this.layerList.get(i).isId(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            GLayer gLayer = new GLayer(this.parent, string, this.dim, this.xLim, this.yLim, this.xLog, this.yLog);
            gLayer.setPoints(gPointsArray);
            this.layerList.add(gLayer);
            if (this.includeAllLayersInLim) {
                this.updateLimits();
            }
        } else {
            PApplet.println((String)"A layer with the same id exists. Please change the id and try to add it again.");
        }
    }

    public void removeLayer(String string) {
        int n = -1;
        for (int i = 0; i < this.layerList.size(); ++i) {
            if (!this.layerList.get(i).isId(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            this.layerList.remove(n);
            if (this.includeAllLayersInLim) {
                this.updateLimits();
            }
        } else {
            PApplet.println((String)("Couldn't find a layer in the plot with id = " + string));
        }
    }

    public float[] getPlotPosAt(float f, float f2) {
        float f3 = f - (this.pos[0] + this.mar[1]);
        float f4 = f2 - (this.pos[1] + this.mar[2] + this.dim[1]);
        return new float[]{f3, f4};
    }

    public float[] getScreenPosAtValue(float f, float f2) {
        float f3 = this.mainLayer.valueToXPlot(f) + (this.pos[0] + this.mar[1]);
        float f4 = this.mainLayer.valueToYPlot(f2) + (this.pos[1] + this.mar[2] + this.dim[1]);
        return new float[]{f3, f4};
    }

    public GPoint getPointAt(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        return this.mainLayer.getPointAtPlotPos(fArray[0], fArray[1]);
    }

    public GPoint getPointAt(float f, float f2, String string) {
        GPoint gPoint = null;
        if (this.mainLayer.isId(string)) {
            gPoint = this.getPointAt(f, f2);
        } else {
            for (int i = 0; i < this.layerList.size(); ++i) {
                if (!this.layerList.get(i).isId(string)) continue;
                float[] fArray = this.getPlotPosAt(f, f2);
                gPoint = this.layerList.get(i).getPointAtPlotPos(fArray[0], fArray[1]);
                break;
            }
        }
        return gPoint;
    }

    public void addPointAt(float f, float f2) {
        float[] fArray = this.getValueAt(f, f2);
        this.addPoint(fArray[0], fArray[1]);
    }

    public void addPointAt(float f, float f2, String string) {
        float[] fArray = this.getValueAt(f, f2);
        this.addPoint(fArray[0], fArray[1], string);
    }

    public void removePointAt(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        int n = this.mainLayer.getPointIndexAtPlotPos(fArray[0], fArray[1]);
        if (n >= 0) {
            this.removePoint(n);
        }
    }

    public void removePointAt(float f, float f2, String string) {
        float[] fArray = this.getPlotPosAt(f, f2);
        int n = this.getLayer(string).getPointIndexAtPlotPos(fArray[0], fArray[1]);
        if (n >= 0) {
            this.removePoint(n, string);
        }
    }

    public float[] getValueAt(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        return this.mainLayer.plotToValue(fArray[0], fArray[1]);
    }

    public float[] getRelativePlotPosAt(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        return new float[]{fArray[0] / this.dim[0], -fArray[1] / this.dim[1]};
    }

    public boolean isOverPlot(float f, float f2) {
        return f >= this.pos[0] && f <= this.pos[0] + this.outerDim[0] && f2 >= this.pos[1] && f2 <= this.pos[1] + this.outerDim[1];
    }

    public boolean isOverBox(float f, float f2) {
        return f >= this.pos[0] + this.mar[1] && f <= this.pos[0] + this.outerDim[0] - this.mar[3] && f2 >= this.pos[1] + this.mar[2] && f2 <= this.pos[1] + this.outerDim[1] - this.mar[0];
    }

    public void updateLimits() {
        if (!this.fixedXLim) {
            this.xLim = this.calculatePlotXLim();
            this.xAxis.setLim(this.xLim);
            this.topAxis.setLim(this.xLim);
        }
        if (!this.fixedYLim) {
            this.yLim = this.calculatePlotYLim();
            this.yAxis.setLim(this.yLim);
            this.rightAxis.setLim(this.yLim);
        }
        this.mainLayer.setXYLim(this.xLim, this.yLim);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).setXYLim(this.xLim, this.yLim);
        }
    }

    protected float[] calculatePlotXLim() {
        float[] fArray = this.calculatePointsXLim(this.mainLayer.getPointsRef());
        if (this.includeAllLayersInLim) {
            for (int i = 0; i < this.layerList.size(); ++i) {
                float[] fArray2 = this.calculatePointsXLim(this.layerList.get(i).getPointsRef());
                if (fArray2 == null) continue;
                if (fArray != null) {
                    fArray[0] = PApplet.min((float)fArray[0], (float)fArray2[0]);
                    fArray[1] = PApplet.max((float)fArray[1], (float)fArray2[1]);
                    continue;
                }
                fArray = fArray2;
            }
        }
        if (fArray != null) {
            float f;
            float f2 = f = fArray[0] == 0.0f ? 0.1f : 0.1f * fArray[0];
            if (this.xLog) {
                if (fArray[0] != fArray[1]) {
                    f = PApplet.exp((float)(this.expandLimFactor * PApplet.log((float)(fArray[1] / fArray[0]))));
                }
                fArray[0] = fArray[0] / f;
                fArray[1] = fArray[1] * f;
            } else {
                if (fArray[0] != fArray[1]) {
                    f = this.expandLimFactor * (fArray[1] - fArray[0]);
                }
                fArray[0] = fArray[0] - f;
                fArray[1] = fArray[1] + f;
            }
        } else {
            fArray = this.xLog && (this.xLim[0] <= 0.0f || this.xLim[1] <= 0.0f) ? new float[]{0.1f, 10.0f} : this.xLim;
        }
        if (this.invertedXScale && fArray[0] < fArray[1]) {
            fArray = new float[]{fArray[1], fArray[0]};
        }
        return fArray;
    }

    protected float[] calculatePlotYLim() {
        float[] fArray = this.calculatePointsYLim(this.mainLayer.getPointsRef());
        if (this.includeAllLayersInLim) {
            for (int i = 0; i < this.layerList.size(); ++i) {
                float[] fArray2 = this.calculatePointsYLim(this.layerList.get(i).getPointsRef());
                if (fArray2 == null) continue;
                if (fArray != null) {
                    fArray[0] = PApplet.min((float)fArray[0], (float)fArray2[0]);
                    fArray[1] = PApplet.max((float)fArray[1], (float)fArray2[1]);
                    continue;
                }
                fArray = fArray2;
            }
        }
        if (fArray != null) {
            float f;
            float f2 = f = fArray[0] == 0.0f ? 0.1f : 0.1f * fArray[0];
            if (this.yLog) {
                if (fArray[0] != fArray[1]) {
                    f = PApplet.exp((float)(this.expandLimFactor * PApplet.log((float)(fArray[1] / fArray[0]))));
                }
                fArray[0] = fArray[0] / f;
                fArray[1] = fArray[1] * f;
            } else {
                if (fArray[0] != fArray[1]) {
                    f = this.expandLimFactor * (fArray[1] - fArray[0]);
                }
                fArray[0] = fArray[0] - f;
                fArray[1] = fArray[1] + f;
            }
        } else {
            fArray = this.yLog && (this.yLim[0] <= 0.0f || this.yLim[1] <= 0.0f) ? new float[]{0.1f, 10.0f} : this.yLim;
        }
        if (this.invertedYScale && fArray[0] < fArray[1]) {
            fArray = new float[]{fArray[1], fArray[0]};
        }
        return fArray;
    }

    public float[] calculatePointsXLim(GPointsArray gPointsArray) {
        float[] fArray = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
            if (!gPointsArray.isValid(i)) continue;
            float f = gPointsArray.getX(i);
            float f2 = gPointsArray.getY(i);
            boolean bl = true;
            if (this.fixedYLim) {
                boolean bl2 = bl = this.yLim[1] >= this.yLim[0] && f2 >= this.yLim[0] && f2 <= this.yLim[1] || this.yLim[1] < this.yLim[0] && f2 <= this.yLim[0] && f2 >= this.yLim[1];
            }
            if (!bl || this.xLog && f <= 0.0f) continue;
            if (f < fArray[0]) {
                fArray[0] = f;
            }
            if (!(f > fArray[1])) continue;
            fArray[1] = f;
        }
        if (fArray[1] < fArray[0]) {
            fArray = null;
        }
        return fArray;
    }

    public float[] calculatePointsYLim(GPointsArray gPointsArray) {
        float[] fArray = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
            if (!gPointsArray.isValid(i)) continue;
            float f = gPointsArray.getX(i);
            float f2 = gPointsArray.getY(i);
            boolean bl = true;
            if (this.fixedXLim) {
                boolean bl2 = bl = this.xLim[1] >= this.xLim[0] && f >= this.xLim[0] && f <= this.xLim[1] || this.xLim[1] < this.xLim[0] && f <= this.xLim[0] && f >= this.xLim[1];
            }
            if (!bl || this.yLog && f2 <= 0.0f) continue;
            if (f2 < fArray[0]) {
                fArray[0] = f2;
            }
            if (!(f2 > fArray[1])) continue;
            fArray[1] = f2;
        }
        if (fArray[1] < fArray[0]) {
            fArray = null;
        }
        return fArray;
    }

    public void moveHorizontalAxesLim(float f) {
        if (this.xLog) {
            float f2 = PApplet.exp((float)(PApplet.log((float)(this.xLim[1] / this.xLim[0])) * f / this.dim[0]));
            this.xLim[0] = this.xLim[0] * f2;
            this.xLim[1] = this.xLim[1] * f2;
        } else {
            float f3 = (this.xLim[1] - this.xLim[0]) * f / this.dim[0];
            this.xLim[0] = this.xLim[0] + f3;
            this.xLim[1] = this.xLim[1] + f3;
        }
        this.fixedXLim = true;
        this.xAxis.moveLim(this.xLim);
        this.topAxis.moveLim(this.xLim);
        this.updateLimits();
    }

    public void moveVerticalAxesLim(float f) {
        if (this.yLog) {
            float f2 = PApplet.exp((float)(PApplet.log((float)(this.yLim[1] / this.yLim[0])) * f / this.dim[1]));
            this.yLim[0] = this.yLim[0] * f2;
            this.yLim[1] = this.yLim[1] * f2;
        } else {
            float f3 = (this.yLim[1] - this.yLim[0]) * f / this.dim[1];
            this.yLim[0] = this.yLim[0] + f3;
            this.yLim[1] = this.yLim[1] + f3;
        }
        this.fixedYLim = true;
        this.yAxis.moveLim(this.yLim);
        this.rightAxis.moveLim(this.yLim);
        this.updateLimits();
    }

    public void centerAndZoom(float f, float f2, float f3) {
        float f4;
        if (this.xLog) {
            f4 = PApplet.exp((float)(PApplet.log((float)(this.xLim[1] / this.xLim[0])) / (2.0f * f)));
            this.xLim = new float[]{f2 / f4, f2 * f4};
        } else {
            f4 = (this.xLim[1] - this.xLim[0]) / (2.0f * f);
            this.xLim = new float[]{f2 - f4, f2 + f4};
        }
        if (this.yLog) {
            f4 = PApplet.exp((float)(PApplet.log((float)(this.yLim[1] / this.yLim[0])) / (2.0f * f)));
            this.yLim = new float[]{f3 / f4, f3 * f4};
        } else {
            f4 = (this.yLim[1] - this.yLim[0]) / (2.0f * f);
            this.yLim = new float[]{f3 - f4, f3 + f4};
        }
        this.fixedXLim = true;
        this.fixedYLim = true;
        this.xAxis.setLim(this.xLim);
        this.topAxis.setLim(this.xLim);
        this.yAxis.setLim(this.yLim);
        this.rightAxis.setLim(this.yLim);
        this.updateLimits();
    }

    public void zoom(float f) {
        float[] fArray = this.mainLayer.plotToValue(this.dim[0] / 2.0f, -this.dim[1] / 2.0f);
        this.centerAndZoom(f, fArray[0], fArray[1]);
    }

    public void zoom(float f, float f2, float f3) {
        float f4;
        float f5;
        float[] fArray = this.getPlotPosAt(f2, f3);
        float[] fArray2 = this.mainLayer.plotToValue(fArray[0], fArray[1]);
        if (this.xLog) {
            f5 = PApplet.exp((float)(PApplet.log((float)(this.xLim[1] / this.xLim[0])) / (2.0f * f)));
            f4 = PApplet.exp((float)(PApplet.log((float)(this.xLim[1] / this.xLim[0])) / f * (0.5f - fArray[0] / this.dim[0])));
            this.xLim = new float[]{fArray2[0] * f4 / f5, fArray2[0] * f4 * f5};
        } else {
            f5 = (this.xLim[1] - this.xLim[0]) / (2.0f * f);
            f4 = 2.0f * f5 * (0.5f - fArray[0] / this.dim[0]);
            this.xLim = new float[]{fArray2[0] + f4 - f5, fArray2[0] + f4 + f5};
        }
        if (this.yLog) {
            f5 = PApplet.exp((float)(PApplet.log((float)(this.yLim[1] / this.yLim[0])) / (2.0f * f)));
            f4 = PApplet.exp((float)(PApplet.log((float)(this.yLim[1] / this.yLim[0])) / f * (0.5f + fArray[1] / this.dim[1])));
            this.yLim = new float[]{fArray2[1] * f4 / f5, fArray2[1] * f4 * f5};
        } else {
            f5 = (this.yLim[1] - this.yLim[0]) / (2.0f * f);
            f4 = 2.0f * f5 * (0.5f + fArray[1] / this.dim[1]);
            this.yLim = new float[]{fArray2[1] + f4 - f5, fArray2[1] + f4 + f5};
        }
        this.fixedXLim = true;
        this.fixedYLim = true;
        this.xAxis.setLim(this.xLim);
        this.topAxis.setLim(this.xLim);
        this.yAxis.setLim(this.yLim);
        this.rightAxis.setLim(this.yLim);
        this.updateLimits();
    }

    protected void shiftPlotPos(float[] fArray, float[] fArray2) {
        float f;
        float f2 = fArray[0] - fArray2[0];
        float f3 = fArray[1] - fArray2[1];
        if (this.xLog) {
            f = PApplet.exp((float)(PApplet.log((float)(this.xLim[1] / this.xLim[0])) * f2 / this.dim[0]));
            this.xLim = new float[]{this.xLim[0] * f, this.xLim[1] * f};
        } else {
            f = (this.xLim[1] - this.xLim[0]) * f2 / this.dim[0];
            this.xLim = new float[]{this.xLim[0] + f, this.xLim[1] + f};
        }
        if (this.yLog) {
            f = PApplet.exp((float)(-PApplet.log((float)(this.yLim[1] / this.yLim[0])) * f3 / this.dim[1]));
            this.yLim = new float[]{this.yLim[0] * f, this.yLim[1] * f};
        } else {
            f = -(this.yLim[1] - this.yLim[0]) * f3 / this.dim[1];
            this.yLim = new float[]{this.yLim[0] + f, this.yLim[1] + f};
        }
        this.fixedXLim = true;
        this.fixedYLim = true;
        this.xAxis.moveLim(this.xLim);
        this.topAxis.moveLim(this.xLim);
        this.yAxis.moveLim(this.yLim);
        this.rightAxis.moveLim(this.yLim);
        this.updateLimits();
    }

    public void align(float f, float f2, float f3, float f4) {
        float[] fArray = this.mainLayer.valueToPlot(f, f2);
        float[] fArray2 = this.getPlotPosAt(f3, f4);
        this.shiftPlotPos(fArray, fArray2);
    }

    public void align(float[] fArray, float f, float f2) {
        this.align(fArray[0], fArray[1], f, f2);
    }

    public void center(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        float[] fArray2 = new float[]{this.dim[0] / 2.0f, -this.dim[1] / 2.0f};
        this.shiftPlotPos(fArray, fArray2);
    }

    public void startHistograms(int n) {
        this.mainLayer.startHistogram(n);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).startHistogram(n);
        }
    }

    public void defaultDraw() {
        this.beginDraw();
        this.drawBackground();
        this.drawBox();
        this.drawXAxis();
        this.drawYAxis();
        this.drawTitle();
        this.drawLines();
        this.drawPoints();
        this.endDraw();
    }

    public void beginDraw() {
        this.parent.pushStyle();
        this.parent.pushMatrix();
        this.parent.translate(this.pos[0] + this.mar[1], this.pos[1] + this.mar[2] + this.dim[1]);
    }

    public void endDraw() {
        this.parent.popMatrix();
        this.parent.popStyle();
    }

    public void drawBackground() {
        this.parent.pushStyle();
        this.parent.rectMode(0);
        this.parent.fill(this.bgColor);
        this.parent.noStroke();
        this.parent.rect(-this.mar[1], -this.mar[2] - this.dim[1], this.outerDim[0], this.outerDim[1]);
        this.parent.popStyle();
    }

    public void drawBox() {
        this.parent.pushStyle();
        this.parent.rectMode(0);
        this.parent.fill(this.boxBgColor);
        this.parent.stroke(this.boxLineColor);
        this.parent.strokeWeight(this.boxLineWidth);
        this.parent.strokeCap(1);
        this.parent.rect(0.0f, -this.dim[1], this.dim[0], this.dim[1]);
        this.parent.popStyle();
    }

    public void drawXAxis() {
        this.xAxis.draw();
    }

    public void drawTopAxis() {
        this.topAxis.draw();
    }

    public void drawYAxis() {
        this.yAxis.draw();
    }

    public void drawRightAxis() {
        this.rightAxis.draw();
    }

    public void drawTitle() {
        this.title.draw();
    }

    public void drawPoints() {
        this.mainLayer.drawPoints();
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawPoints();
        }
    }

    public void drawPoints(PShape pShape) {
        this.mainLayer.drawPoints(pShape);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawPoints(pShape);
        }
    }

    public void drawPoints(PImage pImage) {
        this.mainLayer.drawPoints(pImage);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawPoints(pImage);
        }
    }

    public void drawPoint(GPoint gPoint, int n, float f) {
        this.mainLayer.drawPoint(gPoint, n, f);
    }

    public void drawPoint(GPoint gPoint) {
        this.mainLayer.drawPoint(gPoint);
    }

    public void drawPoint(GPoint gPoint, PShape pShape) {
        this.mainLayer.drawPoint(gPoint, pShape);
    }

    public void drawPoint(GPoint gPoint, PShape pShape, int n) {
        this.mainLayer.drawPoint(gPoint, pShape, n);
    }

    public void drawPoint(GPoint gPoint, PImage pImage) {
        this.mainLayer.drawPoint(gPoint, pImage);
    }

    public void drawLines() {
        this.mainLayer.drawLines();
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawLines();
        }
    }

    public void drawLine(GPoint gPoint, GPoint gPoint2, int n, float f) {
        this.mainLayer.drawLine(gPoint, gPoint2, n, f);
    }

    public void drawLine(GPoint gPoint, GPoint gPoint2) {
        this.mainLayer.drawLine(gPoint, gPoint2);
    }

    public void drawLine(float f, float f2, int n, float f3) {
        this.mainLayer.drawLine(f, f2, n, f3);
    }

    public void drawLine(float f, float f2) {
        this.mainLayer.drawLine(f, f2);
    }

    public void drawHorizontalLine(float f, int n, float f2) {
        this.mainLayer.drawHorizontalLine(f, n, f2);
    }

    public void drawHorizontalLine(float f) {
        this.mainLayer.drawHorizontalLine(f);
    }

    public void drawVerticalLine(float f, int n, float f2) {
        this.mainLayer.drawVerticalLine(f, n, f2);
    }

    public void drawVerticalLine(float f) {
        this.mainLayer.drawVerticalLine(f);
    }

    public void drawFilledContours(int n, float f) {
        this.mainLayer.drawFilledContour(n, f);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawFilledContour(n, f);
        }
    }

    public void drawLabel(GPoint gPoint) {
        this.mainLayer.drawLabel(gPoint);
    }

    public void drawLabelsAt(float f, float f2) {
        float[] fArray = this.getPlotPosAt(f, f2);
        this.mainLayer.drawLabelAtPlotPos(fArray[0], fArray[1]);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawLabelAtPlotPos(fArray[0], fArray[1]);
        }
    }

    public void drawLabels() {
        if (this.labelingIsActive && this.mousePos != null) {
            this.drawLabelsAt(this.mousePos[0], this.mousePos[1]);
        }
    }

    public void drawGridLines(int n) {
        int n2;
        ArrayList<Float> arrayList;
        this.parent.pushStyle();
        this.parent.noFill();
        this.parent.stroke(this.gridLineColor);
        this.parent.strokeWeight(this.gridLineWidth);
        this.parent.strokeCap(1);
        if (n == 2 || n == 0) {
            arrayList = this.xAxis.getPlotTicksRef();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (!(arrayList.get(n2).floatValue() >= 0.0f) || !(arrayList.get(n2).floatValue() <= this.dim[0])) continue;
                this.parent.line(arrayList.get(n2).floatValue(), 0.0f, arrayList.get(n2).floatValue(), -this.dim[1]);
            }
        }
        if (n == 2 || n == 1) {
            arrayList = this.yAxis.getPlotTicksRef();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (!(-arrayList.get(n2).floatValue() >= 0.0f) || !(-arrayList.get(n2).floatValue() <= this.dim[1])) continue;
                this.parent.line(0.0f, arrayList.get(n2).floatValue(), this.dim[0], arrayList.get(n2).floatValue());
            }
        }
        this.parent.popStyle();
    }

    public void drawHistograms() {
        this.mainLayer.drawHistogram();
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).drawHistogram();
        }
    }

    public void drawPolygon(GPointsArray gPointsArray, int n) {
        this.mainLayer.drawPolygon(gPointsArray, n);
    }

    public void drawAnnotation(String string, float f, float f2, int n, int n2) {
        this.mainLayer.drawAnnotation(string, f, f2, n, n2);
    }

    public void drawLegend(String[] stringArray, float[] fArray, float[] fArray2) {
        this.parent.pushStyle();
        this.parent.rectMode(3);
        this.parent.noStroke();
        for (int i = 0; i < stringArray.length; ++i) {
            float[] fArray3 = new float[]{fArray[i] * this.dim[0], -fArray2[i] * this.dim[1]};
            float[] fArray4 = this.mainLayer.plotToValue(fArray3[0], fArray3[1]);
            if (i == 0) {
                this.parent.fill(this.mainLayer.getLineColor());
                this.parent.rect(fArray3[0] - 15.0f, fArray3[1], 14.0f, 14.0f);
                this.mainLayer.drawAnnotation(stringArray[i], fArray4[0], fArray4[1], 37, 3);
                continue;
            }
            this.parent.fill(this.layerList.get(i - 1).getLineColor());
            this.parent.rect(fArray3[0] - 15.0f, fArray3[1], 14.0f, 14.0f);
            this.layerList.get(i - i).drawAnnotation(stringArray[i], fArray4[0], fArray4[1], 37, 3);
        }
        this.parent.popStyle();
    }

    public void setPos(float f, float f2) {
        this.pos[0] = f;
        this.pos[1] = f2;
    }

    public void setPos(float[] fArray) {
        this.setPos(fArray[0], fArray[1]);
    }

    public void setOuterDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            float f3 = f - this.mar[1] - this.mar[3];
            float f4 = f2 - this.mar[0] - this.mar[2];
            if (f3 > 0.0f && f4 > 0.0f) {
                this.outerDim[0] = f;
                this.outerDim[1] = f2;
                this.dim[0] = f3;
                this.dim[1] = f4;
                this.xAxis.setDim(this.dim);
                this.topAxis.setDim(this.dim);
                this.yAxis.setDim(this.dim);
                this.rightAxis.setDim(this.dim);
                this.title.setDim(this.dim);
                this.mainLayer.setDim(this.dim);
                for (int i = 0; i < this.layerList.size(); ++i) {
                    this.layerList.get(i).setDim(this.dim);
                }
            }
        }
    }

    public void setOuterDim(float[] fArray) {
        this.setOuterDim(fArray[0], fArray[1]);
    }

    public void setMar(float f, float f2, float f3, float f4) {
        float f5 = this.dim[0] + f2 + f4;
        float f6 = this.dim[1] + f + f3;
        if (f5 > 0.0f && f6 > 0.0f) {
            this.mar[0] = f;
            this.mar[1] = f2;
            this.mar[2] = f3;
            this.mar[3] = f4;
            this.outerDim[0] = f5;
            this.outerDim[1] = f6;
        }
    }

    public void setMar(float[] fArray) {
        this.setMar(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            float f3 = f + this.mar[1] + this.mar[3];
            float f4 = f2 + this.mar[0] + this.mar[2];
            if (f3 > 0.0f && f4 > 0.0f) {
                this.outerDim[0] = f3;
                this.outerDim[1] = f4;
                this.dim[0] = f;
                this.dim[1] = f2;
                this.xAxis.setDim(this.dim);
                this.topAxis.setDim(this.dim);
                this.yAxis.setDim(this.dim);
                this.rightAxis.setDim(this.dim);
                this.title.setDim(this.dim);
                this.mainLayer.setDim(this.dim);
                for (int i = 0; i < this.layerList.size(); ++i) {
                    this.layerList.get(i).setDim(this.dim);
                }
            }
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setXLim(float f, float f2) {
        if (f != f2) {
            if (this.xLog && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.xLim[0] = f;
                this.xLim[1] = f2;
                this.invertedXScale = this.xLim[0] > this.xLim[1];
                this.fixedXLim = true;
                this.xAxis.setLim(this.xLim);
                this.topAxis.setLim(this.xLim);
                this.updateLimits();
            }
        }
    }

    public void setXLim(float[] fArray) {
        this.setXLim(fArray[0], fArray[1]);
    }

    public void setYLim(float f, float f2) {
        if (f != f2) {
            if (this.yLog && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.yLim[0] = f;
                this.yLim[1] = f2;
                this.invertedYScale = this.yLim[0] > this.yLim[1];
                this.fixedYLim = true;
                this.yAxis.setLim(this.yLim);
                this.rightAxis.setLim(this.yLim);
                this.updateLimits();
            }
        }
    }

    public void setYLim(float[] fArray) {
        this.setYLim(fArray[0], fArray[1]);
    }

    public void setFixedXLim(boolean bl) {
        this.fixedXLim = bl;
        this.updateLimits();
    }

    public void setFixedYLim(boolean bl) {
        this.fixedYLim = bl;
        this.updateLimits();
    }

    public void setLogScale(String string) {
        boolean bl = this.xLog;
        boolean bl2 = this.yLog;
        if (string.equals("xy") || string.equals("yx")) {
            bl = true;
            bl2 = true;
        } else if (string.equals("x")) {
            bl = true;
            bl2 = false;
        } else if (string.equals("y")) {
            bl = false;
            bl2 = true;
        } else if (string.equals("")) {
            bl = false;
            bl2 = false;
        }
        if (bl != this.xLog || bl2 != this.yLog) {
            this.xLog = bl;
            this.yLog = bl2;
            if (this.xLog && this.fixedXLim && (this.xLim[0] <= 0.0f || this.xLim[1] <= 0.0f)) {
                this.fixedXLim = false;
            }
            if (this.yLog && this.fixedYLim && (this.yLim[0] <= 0.0f || this.yLim[1] <= 0.0f)) {
                this.fixedYLim = false;
            }
            if (!this.fixedXLim) {
                this.xLim = this.calculatePlotXLim();
            }
            if (!this.fixedYLim) {
                this.yLim = this.calculatePlotYLim();
            }
            this.xAxis.setLimAndLog(this.xLim, this.xLog);
            this.topAxis.setLimAndLog(this.xLim, this.xLog);
            this.yAxis.setLimAndLog(this.yLim, this.yLog);
            this.rightAxis.setLimAndLog(this.yLim, this.yLog);
            this.mainLayer.setLimAndLog(this.xLim, this.yLim, this.xLog, this.yLog);
            for (int i = 0; i < this.layerList.size(); ++i) {
                this.layerList.get(i).setLimAndLog(this.xLim, this.yLim, this.xLog, this.yLog);
            }
        }
    }

    public void setInvertedXScale(boolean bl) {
        if (bl != this.invertedXScale) {
            this.invertedXScale = bl;
            float f = this.xLim[0];
            this.xLim[0] = this.xLim[1];
            this.xLim[1] = f;
            this.xAxis.setLim(this.xLim);
            this.topAxis.setLim(this.xLim);
            this.mainLayer.setXLim(this.xLim);
            for (int i = 0; i < this.layerList.size(); ++i) {
                this.layerList.get(i).setXLim(this.xLim);
            }
        }
    }

    public void invertXScale() {
        this.setInvertedXScale(!this.invertedXScale);
    }

    public void setInvertedYScale(boolean bl) {
        if (bl != this.invertedYScale) {
            this.invertedYScale = bl;
            float f = this.yLim[0];
            this.yLim[0] = this.yLim[1];
            this.yLim[1] = f;
            this.yAxis.setLim(this.yLim);
            this.rightAxis.setLim(this.yLim);
            this.mainLayer.setYLim(this.yLim);
            for (int i = 0; i < this.layerList.size(); ++i) {
                this.layerList.get(i).setYLim(this.yLim);
            }
        }
    }

    public void invertYScale() {
        this.setInvertedYScale(!this.invertedYScale);
    }

    public void setIncludeAllLayersInLim(boolean bl) {
        if (bl != this.includeAllLayersInLim) {
            this.includeAllLayersInLim = bl;
            this.updateLimits();
        }
    }

    public void setExpandLimFactor(float f) {
        if (f >= 0.0f && f != this.expandLimFactor) {
            this.expandLimFactor = f;
            this.updateLimits();
        }
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public void setBoxBgColor(int n) {
        this.boxBgColor = n;
    }

    public void setBoxLineColor(int n) {
        this.boxLineColor = n;
    }

    public void setBoxLineWidth(float f) {
        if (f > 0.0f) {
            this.boxLineWidth = f;
        }
    }

    public void setGridLineColor(int n) {
        this.gridLineColor = n;
    }

    public void setGridLineWidth(float f) {
        if (f > 0.0f) {
            this.gridLineWidth = f;
        }
    }

    public void setPoints(GPointsArray gPointsArray) {
        this.mainLayer.setPoints(gPointsArray);
        this.updateLimits();
    }

    public void setPoints(GPointsArray gPointsArray, String string) {
        this.getLayer(string).setPoints(gPointsArray);
        this.updateLimits();
    }

    public void setPoint(int n, float f, float f2, String string) {
        this.mainLayer.setPoint(n, f, f2, string);
        this.updateLimits();
    }

    public void setPoint(int n, float f, float f2, String string, String string2) {
        this.getLayer(string2).setPoint(n, f, f2, string);
        this.updateLimits();
    }

    public void setPoint(int n, float f, float f2) {
        this.mainLayer.setPoint(n, f, f2);
        this.updateLimits();
    }

    public void setPoint(int n, GPoint gPoint) {
        this.mainLayer.setPoint(n, gPoint);
        this.updateLimits();
    }

    public void setPoint(int n, GPoint gPoint, String string) {
        this.getLayer(string).setPoint(n, gPoint);
        this.updateLimits();
    }

    public void addPoint(float f, float f2, String string) {
        this.mainLayer.addPoint(f, f2, string);
        this.updateLimits();
    }

    public void addPoint(float f, float f2, String string, String string2) {
        this.getLayer(string2).addPoint(f, f2, string);
        this.updateLimits();
    }

    public void addPoint(float f, float f2) {
        this.mainLayer.addPoint(f, f2);
        this.updateLimits();
    }

    public void addPoint(GPoint gPoint) {
        this.mainLayer.addPoint(gPoint);
        this.updateLimits();
    }

    public void addPoint(GPoint gPoint, String string) {
        this.getLayer(string).addPoint(gPoint);
        this.updateLimits();
    }

    public void addPoint(int n, float f, float f2, String string) {
        this.mainLayer.addPoint(n, f, f2, string);
        this.updateLimits();
    }

    public void addPoint(int n, float f, float f2, String string, String string2) {
        this.getLayer(string2).addPoint(n, f, f2, string);
        this.updateLimits();
    }

    public void addPoint(int n, float f, float f2) {
        this.mainLayer.addPoint(n, f, f2);
        this.updateLimits();
    }

    public void addPoint(int n, GPoint gPoint) {
        this.mainLayer.addPoint(n, gPoint);
        this.updateLimits();
    }

    public void addPoint(int n, GPoint gPoint, String string) {
        this.getLayer(string).addPoint(n, gPoint);
        this.updateLimits();
    }

    public void addPoints(GPointsArray gPointsArray) {
        this.mainLayer.addPoints(gPointsArray);
        this.updateLimits();
    }

    public void addPoints(GPointsArray gPointsArray, String string) {
        this.getLayer(string).addPoints(gPointsArray);
        this.updateLimits();
    }

    public void removePoint(int n) {
        this.mainLayer.removePoint(n);
        this.updateLimits();
    }

    public void removePoint(int n, String string) {
        this.getLayer(string).removePoint(n);
        this.updateLimits();
    }

    public void setPointColors(int[] nArray) {
        this.mainLayer.setPointColors(nArray);
    }

    public void setPointColor(int n) {
        this.mainLayer.setPointColor(n);
    }

    public void setPointSizes(float[] fArray) {
        this.mainLayer.setPointSizes(fArray);
    }

    public void setPointSize(float f) {
        this.mainLayer.setPointSize(f);
    }

    public void setLineColor(int n) {
        this.mainLayer.setLineColor(n);
    }

    public void setLineWidth(float f) {
        this.mainLayer.setLineWidth(f);
    }

    public void setHistBasePoint(GPoint gPoint) {
        this.mainLayer.setHistBasePoint(gPoint);
    }

    public void setHistType(int n) {
        this.mainLayer.setHistType(n);
    }

    public void setHistVisible(boolean bl) {
        this.mainLayer.setHistVisible(bl);
    }

    public void setDrawHistLabels(boolean bl) {
        this.mainLayer.setDrawHistLabels(bl);
    }

    public void setLabelBgColor(int n) {
        this.mainLayer.setLabelBgColor(n);
    }

    public void setLabelSeparation(float[] fArray) {
        this.mainLayer.setLabelSeparation(fArray);
    }

    public void setTitleText(String string) {
        this.title.setText(string);
    }

    public void setAxesOffset(float f) {
        this.xAxis.setOffset(f);
        this.topAxis.setOffset(f);
        this.yAxis.setOffset(f);
        this.rightAxis.setOffset(f);
    }

    public void setTicksLength(float f) {
        this.xAxis.setTickLength(f);
        this.topAxis.setTickLength(f);
        this.yAxis.setTickLength(f);
        this.rightAxis.setTickLength(f);
    }

    public void setHorizontalAxesNTicks(int n) {
        this.xAxis.setNTicks(n);
        this.topAxis.setNTicks(n);
    }

    public void setHorizontalAxesTicksSeparation(float f) {
        this.xAxis.setTicksSeparation(f);
        this.topAxis.setTicksSeparation(f);
    }

    public void setHorizontalAxesTicks(float[] fArray) {
        this.xAxis.setTicks(fArray);
        this.topAxis.setTicks(fArray);
    }

    public void setVerticalAxesNTicks(int n) {
        this.yAxis.setNTicks(n);
        this.rightAxis.setNTicks(n);
    }

    public void setVerticalAxesTicksSeparation(float f) {
        this.yAxis.setTicksSeparation(f);
        this.rightAxis.setTicksSeparation(f);
    }

    public void setVerticalAxesTicks(float[] fArray) {
        this.yAxis.setTicks(fArray);
        this.rightAxis.setTicks(fArray);
    }

    public void setFontName(String string) {
        this.mainLayer.setFontName(string);
    }

    public void setFontColor(int n) {
        this.mainLayer.setFontColor(n);
    }

    public void setFontSize(int n) {
        this.mainLayer.setFontSize(n);
    }

    public void setFontProperties(String string, int n, int n2) {
        this.mainLayer.setFontProperties(string, n, n2);
    }

    public void setAllFontProperties(String string, int n, int n2) {
        this.xAxis.setAllFontProperties(string, n, n2);
        this.topAxis.setAllFontProperties(string, n, n2);
        this.yAxis.setAllFontProperties(string, n, n2);
        this.rightAxis.setAllFontProperties(string, n, n2);
        this.title.setFontProperties(string, n, n2);
        this.mainLayer.setAllFontProperties(string, n, n2);
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).setAllFontProperties(string, n, n2);
        }
    }

    public float[] getPos() {
        return (float[])this.pos.clone();
    }

    public float[] getOuterDim() {
        return (float[])this.outerDim.clone();
    }

    public float[] getMar() {
        return (float[])this.mar.clone();
    }

    public float[] getDim() {
        return (float[])this.dim.clone();
    }

    public float[] getXLim() {
        return (float[])this.xLim.clone();
    }

    public float[] getYLim() {
        return (float[])this.yLim.clone();
    }

    public boolean getFixedXLim() {
        return this.fixedXLim;
    }

    public boolean getFixedYLim() {
        return this.fixedYLim;
    }

    public boolean getXLog() {
        return this.xLog;
    }

    public boolean getYLog() {
        return this.yLog;
    }

    public boolean getInvertedXScale() {
        return this.invertedXScale;
    }

    public boolean getInvertedYScale() {
        return this.invertedYScale;
    }

    public GLayer getMainLayer() {
        return this.mainLayer;
    }

    public GLayer getLayer(String string) {
        GLayer gLayer = null;
        if (this.mainLayer.isId(string)) {
            gLayer = this.mainLayer;
        } else {
            for (int i = 0; i < this.layerList.size(); ++i) {
                if (!this.layerList.get(i).isId(string)) continue;
                gLayer = this.layerList.get(i);
                break;
            }
        }
        if (gLayer == null) {
            PApplet.println((String)("Couldn't find a layer in the plot with id = " + string));
        }
        return gLayer;
    }

    public GAxis getXAxis() {
        return this.xAxis;
    }

    public GAxis getTopAxis() {
        return this.topAxis;
    }

    public GAxis getYAxis() {
        return this.yAxis;
    }

    public GAxis getRightAxis() {
        return this.rightAxis;
    }

    public GTitle getTitle() {
        return this.title;
    }

    public GPointsArray getPoints() {
        return this.mainLayer.getPoints();
    }

    public GPointsArray getPoints(String string) {
        return this.getLayer(string).getPoints();
    }

    public GPointsArray getPointsRef() {
        return this.mainLayer.getPointsRef();
    }

    public GPointsArray getPointsRef(String string) {
        return this.getLayer(string).getPointsRef();
    }

    public GHistogram getHistogram() {
        return this.mainLayer.getHistogram();
    }

    public GHistogram getHistogram(String string) {
        return this.getLayer(string).getHistogram();
    }

    public void activateZooming(float f, int n, int n2, int n3, int n4) {
        this.zoomingIsActive = true;
        if (f > 0.0f) {
            this.zoomFactor = f;
        }
        if (n == 37 || n == 39 || n == 3) {
            this.increaseZoomButton = n;
        }
        if (n2 == 37 || n2 == 39 || n2 == 3) {
            this.decreaseZoomButton = n2;
        }
        if (n3 == 1 || n3 == 2 || n3 == 4 || n3 == 8 || n3 == 0) {
            this.increaseZoomKeyModifier = n3;
        }
        if (n4 == 1 || n4 == 2 || n4 == 4 || n4 == 8 || n4 == 0) {
            this.decreaseZoomKeyModifier = n4;
        }
    }

    public void activateZooming(float f, int n, int n2) {
        this.activateZooming(f, n, n2, 0, 0);
    }

    public void activateZooming(float f) {
        this.activateZooming(f, 37, 39, 0, 0);
    }

    public void activateZooming() {
        this.activateZooming(1.3f, 37, 39, 0, 0);
    }

    public void deactivateZooming() {
        this.zoomingIsActive = false;
    }

    public void activateCentering(int n, int n2) {
        this.centeringIsActive = true;
        if (n == 37 || n == 39 || n == 3) {
            this.centeringButton = n;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 0) {
            this.centeringKeyModifier = n2;
        }
    }

    public void activateCentering(int n) {
        this.activateCentering(n, 0);
    }

    public void activateCentering() {
        this.activateCentering(37, 0);
    }

    public void deactivateCentering() {
        this.centeringIsActive = false;
    }

    public void activatePanning(int n, int n2) {
        this.panningIsActive = true;
        if (n == 37 || n == 39 || n == 3) {
            this.panningButton = n;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 0) {
            this.panningKeyModifier = n2;
        }
    }

    public void activatePanning(int n) {
        this.activatePanning(n, 0);
    }

    public void activatePanning() {
        this.activatePanning(37, 0);
    }

    public void deactivatePanning() {
        this.panningIsActive = false;
        this.panningReferencePoint = null;
    }

    public void activatePointLabels(int n, int n2) {
        this.labelingIsActive = true;
        if (n == 37 || n == 39 || n == 3) {
            this.labelingButton = n;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 0) {
            this.labelingKeyModifier = n2;
        }
    }

    public void activatePointLabels(int n) {
        this.activatePointLabels(n, 0);
    }

    public void activatePointLabels() {
        this.activatePointLabels(37, 0);
    }

    public void deactivatePointLabels() {
        this.labelingIsActive = false;
        this.mousePos = null;
    }

    public void activateReset(int n, int n2) {
        this.resetIsActive = true;
        this.xLimReset = null;
        this.yLimReset = null;
        if (n == 37 || n == 39 || n == 3) {
            this.resetButton = n;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 0) {
            this.resetKeyModifier = n2;
        }
    }

    public void activateReset(int n) {
        this.activateReset(n, 0);
    }

    public void activateReset() {
        this.activateReset(39, 0);
    }

    public void deactivateReset() {
        this.resetIsActive = false;
        this.xLimReset = null;
        this.yLimReset = null;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.zoomingIsActive || this.centeringIsActive || this.panningIsActive || this.labelingIsActive || this.resetIsActive) {
            int n;
            int n2 = mouseEvent.getAction();
            int n3 = n2 == 8 ? 3 : mouseEvent.getButton();
            int n4 = mouseEvent.getModifiers();
            float f = mouseEvent.getX();
            float f2 = mouseEvent.getY();
            int n5 = n = n2 == 8 ? mouseEvent.getCount() : 0;
            if (this.zoomingIsActive && (n2 == 3 || n2 == 8)) {
                if (n3 == this.increaseZoomButton && (this.increaseZoomKeyModifier == 0 || (n4 & this.increaseZoomKeyModifier) != 0) && this.isOverBox(f, f2)) {
                    if (this.resetIsActive && (this.xLimReset == null || this.yLimReset == null)) {
                        this.xLimReset = (float[])this.xLim.clone();
                        this.yLimReset = (float[])this.yLim.clone();
                    }
                    if (n <= 0) {
                        this.zoom(this.zoomFactor, f, f2);
                    }
                }
                if (n3 == this.decreaseZoomButton && (this.decreaseZoomKeyModifier == 0 || (n4 & this.decreaseZoomKeyModifier) != 0) && this.isOverBox(f, f2)) {
                    if (this.resetIsActive && (this.xLimReset == null || this.yLimReset == null)) {
                        this.xLimReset = (float[])this.xLim.clone();
                        this.yLimReset = (float[])this.yLim.clone();
                    }
                    if (n >= 0) {
                        this.zoom(1.0f / this.zoomFactor, f, f2);
                    }
                }
            }
            if (this.centeringIsActive && (n2 == 3 || n2 == 8) && n3 == this.centeringButton && (this.centeringKeyModifier == 0 || (n4 & this.centeringKeyModifier) != 0) && this.isOverBox(f, f2)) {
                if (this.resetIsActive && (this.xLimReset == null || this.yLimReset == null)) {
                    this.xLimReset = (float[])this.xLim.clone();
                    this.yLimReset = (float[])this.yLim.clone();
                }
                this.center(f, f2);
            }
            if (this.panningIsActive && n3 == this.panningButton && (this.panningKeyModifier == 0 || (n4 & this.panningKeyModifier) != 0)) {
                if (n2 == 4) {
                    if (this.panningReferencePoint != null) {
                        if (this.resetIsActive && (this.xLimReset == null || this.yLimReset == null)) {
                            this.xLimReset = (float[])this.xLim.clone();
                            this.yLimReset = (float[])this.yLim.clone();
                        }
                        this.align(this.panningReferencePoint, f, f2);
                    } else if (this.isOverBox(f, f2)) {
                        this.panningReferencePoint = this.getValueAt(f, f2);
                    }
                } else if (n2 == 2) {
                    this.panningReferencePoint = null;
                }
            }
            if (this.labelingIsActive && n3 == this.labelingButton && (this.labelingKeyModifier == 0 || (n4 & this.labelingKeyModifier) != 0)) {
                this.mousePos = (float[])((n2 == 1 || n2 == 4) && this.isOverBox(f, f2) ? new float[]{f, f2} : null);
            }
            if (this.resetIsActive && (n2 == 3 || n2 == 8) && n3 == this.resetButton && (this.resetKeyModifier == 0 || (n4 & this.resetKeyModifier) != 0) && this.isOverBox(f, f2) && this.xLimReset != null && this.yLimReset != null) {
                this.setXLim(this.xLimReset);
                this.setYLim(this.yLimReset);
                this.xLimReset = null;
                this.yLimReset = null;
            }
        }
    }
}

