/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import grafica.GPoint;
import java.util.ArrayList;
import java.util.Iterator;
import processing.core.PVector;

public class GPointsArray {
    protected ArrayList<GPoint> points;

    public GPointsArray() {
        this.points = new ArrayList();
    }

    public GPointsArray(int n) {
        this.points = new ArrayList(n);
    }

    public GPointsArray(GPoint[] gPointArray) {
        this.points = new ArrayList(gPointArray.length);
        for (int i = 0; i < gPointArray.length; ++i) {
            if (gPointArray[i] == null) continue;
            this.points.add(new GPoint(gPointArray[i]));
        }
    }

    public GPointsArray(GPointsArray gPointsArray) {
        this.points = new ArrayList(gPointsArray.getNPoints());
        for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
            this.points.add(new GPoint(gPointsArray.get(i)));
        }
    }

    public GPointsArray(float[] fArray, float[] fArray2, String[] stringArray) {
        this.points = new ArrayList(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.points.add(new GPoint(fArray[i], fArray2[i], stringArray[i]));
        }
    }

    public GPointsArray(float[] fArray, float[] fArray2) {
        this.points = new ArrayList(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.points.add(new GPoint(fArray[i], fArray2[i]));
        }
    }

    public GPointsArray(PVector[] pVectorArray, String[] stringArray) {
        this.points = new ArrayList(pVectorArray.length);
        for (int i = 0; i < pVectorArray.length; ++i) {
            this.points.add(new GPoint(pVectorArray[i], stringArray[i]));
        }
    }

    public GPointsArray(PVector[] pVectorArray) {
        this.points = new ArrayList(pVectorArray.length);
        for (int i = 0; i < pVectorArray.length; ++i) {
            this.points.add(new GPoint(pVectorArray[i]));
        }
    }

    public GPointsArray(ArrayList<PVector> arrayList) {
        this.points = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.points.add(new GPoint(arrayList.get(i)));
        }
    }

    public void add(GPoint gPoint) {
        this.points.add(new GPoint(gPoint));
    }

    public void add(float f, float f2, String string) {
        this.points.add(new GPoint(f, f2, string));
    }

    public void add(float f, float f2) {
        this.points.add(new GPoint(f, f2));
    }

    public void add(PVector pVector, String string) {
        this.points.add(new GPoint(pVector, string));
    }

    public void add(PVector pVector) {
        this.points.add(new GPoint(pVector));
    }

    public void add(int n, GPoint gPoint) {
        this.points.add(n, new GPoint(gPoint));
    }

    public void add(int n, float f, float f2, String string) {
        this.points.add(n, new GPoint(f, f2, string));
    }

    public void add(int n, float f, float f2) {
        this.points.add(n, new GPoint(f, f2));
    }

    public void add(int n, PVector pVector, String string) {
        this.points.add(n, new GPoint(pVector, string));
    }

    public void add(int n, PVector pVector) {
        this.points.add(n, new GPoint(pVector));
    }

    public void add(GPoint[] gPointArray) {
        for (int i = 0; i < gPointArray.length; ++i) {
            this.points.add(new GPoint(gPointArray[i]));
        }
    }

    public void add(GPointsArray gPointsArray) {
        for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
            this.points.add(new GPoint(gPointsArray.get(i)));
        }
    }

    public void add(float[] fArray, float[] fArray2, String[] stringArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.points.add(new GPoint(fArray[i], fArray2[i], stringArray[i]));
        }
    }

    public void add(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            this.points.add(new GPoint(fArray[i], fArray2[i]));
        }
    }

    public void add(PVector[] pVectorArray, String[] stringArray) {
        for (int i = 0; i < pVectorArray.length; ++i) {
            this.points.add(new GPoint(pVectorArray[i], stringArray[i]));
        }
    }

    public void add(PVector[] pVectorArray) {
        for (int i = 0; i < pVectorArray.length; ++i) {
            this.points.add(new GPoint(pVectorArray[i]));
        }
    }

    public void add(ArrayList<PVector> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.points.add(new GPoint(arrayList.get(i)));
        }
    }

    public void remove(int n) {
        this.points.remove(n);
    }

    public void removeRange(int n, int n2) {
        this.points.subList(n, n2).clear();
    }

    public void removeInvalidPoints() {
        Iterator<GPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isValid()) continue;
            iterator.remove();
        }
    }

    public void set(GPointsArray gPointsArray) {
        if (gPointsArray.getNPoints() == this.points.size()) {
            for (int i = 0; i < this.points.size(); ++i) {
                this.points.get(i).set(gPointsArray.get(i));
            }
        } else if (gPointsArray.getNPoints() > this.points.size()) {
            int n;
            for (n = 0; n < this.points.size(); ++n) {
                this.points.get(n).set(gPointsArray.get(n));
            }
            for (n = this.points.size(); n < gPointsArray.getNPoints(); ++n) {
                this.points.add(new GPoint(gPointsArray.get(n)));
            }
        } else {
            for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
                this.points.get(i).set(gPointsArray.get(i));
            }
            this.points.subList(gPointsArray.getNPoints(), this.points.size()).clear();
        }
    }

    public void set(int n, GPoint gPoint) {
        if (n == this.points.size()) {
            this.points.add(new GPoint(gPoint));
        } else {
            this.points.get(n).set(gPoint);
        }
    }

    public void set(int n, float f, float f2, String string) {
        if (n == this.points.size()) {
            this.points.add(new GPoint(f, f2, string));
        } else {
            this.points.get(n).set(f, f2, string);
        }
    }

    public void set(int n, PVector pVector, String string) {
        if (n == this.points.size()) {
            this.points.add(new GPoint(pVector, string));
        } else {
            this.points.get(n).set(pVector, string);
        }
    }

    public void setX(int n, float f) {
        this.points.get(n).setX(f);
    }

    public void setY(int n, float f) {
        this.points.get(n).setY(f);
    }

    public void setXY(int n, float f, float f2) {
        this.points.get(n).setXY(f, f2);
    }

    public void setXY(int n, PVector pVector) {
        this.points.get(n).setXY(pVector);
    }

    public void setLabel(int n, String string) {
        this.points.get(n).setLabel(string);
    }

    public void setNPoints(int n) {
        this.points.subList(n, this.points.size()).clear();
    }

    public int getNPoints() {
        return this.points.size();
    }

    public GPoint get(int n) {
        return this.points.get(n);
    }

    public float getX(int n) {
        return this.points.get(n).getX();
    }

    public float getY(int n) {
        return this.points.get(n).getY();
    }

    public String getLabel(int n) {
        return this.points.get(n).getLabel();
    }

    public boolean getValid(int n) {
        return this.points.get(n).getValid();
    }

    public boolean isValid(int n) {
        return this.points.get(n).isValid();
    }

    public GPoint getLastPoint() {
        return this.points.size() > 0 ? this.points.get(this.points.size() - 1) : null;
    }
}

