# If you have multiple .lib files put them in a [list lib1 lib2] structure
create_library_set -name typical_lib \
    -timing ${STM65}/CORE65LPSVT/5.2.c/libs/CORE65LPSVT_nom_1.10V_25C.lib

# Specify the .sdc timing constraint file to use
create_constraint_mode -name typical_constraint \
    -sdc_files inputs/ALU_RCA.sdc

#################################################################
# Below here you shouldn't have to change, unless you're doing
# something different than the basic EDI run...
#################################################################
# Create an RC_corner that has specific capacitance info.
create_rc_corner -name typical_rc \
    -qx_tech_file ${STM65}/SignOffTechnoKit_cmos065lp_7m4x0y2z/5.4-01/etc/QrcTechLibs/RCTYP/RCTYP.tech

# Define delay corners and analysis views.
create_delay_corner -name typical_corner \
    -library_set typical_lib \
    -rc_corner typical_rc

# Now define which analysis view to use for setup and for hold.
create_analysis_view -name typical_view \
    -constraint_mode typical_constraint \
    -delay_corner typical_corner

set_analysis_view -setup typical_view -hold typical_view
