--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      
use ieee.numeric_std.all;
use ieee.math_real.all;

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity shift_module is
   generic( width : natural := 32);
            
   port (
      clk:in std_logic;
      reset_n : std_logic;
      A : in std_logic_vector(width-1 downto 0);
      B : in std_logic_vector(integer(floor(log2(real(width))))-1 downto 0); -- shift-count. Max shift 31 positions.
      OP: in std_logic_vector(1 downto 0);
      S : out std_logic_vector(width-1 downto 0)
   );
end entity shift_module;

architecture struct of shift_module is

   component vDFF is
      generic(WIDTH : natural);
      port (clk   : in std_logic; 
            D     : in std_logic_vector(WIDTH-1 downto 0);
            Q     : out std_logic_vector(WIDTH-1 downto 0));
   end component vDFF;
   
   component mux41 is 
      generic(width : natural := 32);
      port (mux41_in_0  : in std_logic_vector (width-1 downto 0);
            mux41_in_1  : in std_logic_vector (width-1 downto 0);
            mux41_in_2  : in std_logic_vector (width-1 downto 0);
            mux41_in_3  : in std_logic_vector (width-1 downto 0);
            mux41_sel   : in std_logic_vector(1 downto 0);
            mux41_out   : out std_logic_vector (width-1 downto 0));
   end component mux41;
   
   signal nxt     : std_logic_vector(width-1 downto 0); -- next state ie. value post-shift.
   signal sh_o     : std_logic_vector(width-1 downto 0); 
   
   signal sll_s, srl_s, sra_s : std_logic_vector(width-1 downto 0);
begin

   -- nxt <=   (others => '0') when reset_n='0' else -- active low synchronous reset.
            -- std_logic_vector(unsigned(A) sll to_integer(unsigned(B))); -- Shift A logical left B places.

   sll_s <= std_logic_vector(shift_left(unsigned(A), natural(to_integer(unsigned(B)))));  -- shift using functions.
   srl_s <= std_logic_vector(shift_right(unsigned(A), natural(to_integer(unsigned(B))))); 
   sra_s <= std_logic_vector(shift_right(signed(A), natural(to_integer(unsigned(B)))));  
   
      
   comp_mux41 : mux41
   generic map (width => width)
   port map (mux41_in_0 => sll_s,
             mux41_in_1 => (others => '1'), -- opcode 1001 undefined.
             mux41_in_2 => srl_s,
             mux41_in_3 => sra_s,
             mux41_sel  => OP,
             mux41_out  => sh_o);

   S <=   (others => '0') when reset_n='0' else
            sh_o;

   -- shift_reg : vDFF
   -- generic map (WIDTH => WIDTH)
   -- port map (clk => clk,
             -- D   => nxt,
             -- Q   => S);


end architecture struct;