--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity add_sub_module is
   generic(width : natural := 32);
   port (
      A : in std_logic_vector(width-1 downto 0); -- Consider defining a subtype and packaging.
      B : in std_logic_vector(width-1 downto 0);
      OP: in std_logic_vector(1 downto 0);  -- mux select using opcode. At the moment only chooses subtraction via cin, but may be used to set various arithmetic flags in future.
      S : out std_logic_vector(width-1 downto 0);
      V_flag : out std_logic;
      Co : out std_logic
   );
end entity add_sub_module;

--========================================== Architecture Head ==========================================
architecture struct of add_sub_module is
   --==== Component Declaration ====--
      --== MUX12 ==--
      component mux21 IS 
      generic(width : natural);
      PORT (mux21_in_0  : in STD_LOGIC_VECTOR (width-1 downto 0);
            mux21_in_1  : in STD_LOGIC_VECTOR (width-1 downto 0);
            mux21_sel   : in STD_LOGIC;
            mux21_out   : OUT STD_LOGIC_VECTOR (width-1 downto 0));
      end component mux21;
   
      --== RCA ==--
      component rca_generic is
      generic(width : natural);
      port (a     :  in std_logic_vector(width-1 downto 0);
            b     :  in std_logic_vector(width-1 downto 0);
            c_in  :  in std_logic; 
            c_out :  out std_logic;
            V_flag : out std_logic;
            y     :  out std_logic_vector(width-1 downto 0));
      end component rca_generic;
      
   --==== Signals ====--
   signal B_inv : std_logic_vector(width-1 downto 0); -- B 1's complement.
   signal B_muxed : std_logic_vector(width-1 downto 0);
   signal c_out : std_logic; -- may or may not be used...
   signal V_flag_s : std_logic;
   
--========================================== Architecture Body ==========================================
begin
   --==== Static Assignments ====--
   B_inv <= not B;
   Co <= c_out;
   V_flag <= V_flag_s;

   -- subttraction if OP(1)='1', -> cin <= '1'
   --==== Component Instantiation ====--
      --== MUX12 ==--
      comp_mux21 : mux21 
      generic map (width => width)
      port map (mux21_in_0  => B,
                mux21_in_1  => B_inv, -- can not write "not B", as port map must be globally static in VHDL<2008.
                mux21_sel   => OP(1),
                mux21_out   => B_muxed);

      --== RCA ==--
         comp_rca_generic : rca_generic
      generic map (width => width)
      port map (a       => A,
                b       => B_muxed,
                c_in    => OP(1), -- opcode directly determines if subtraction taking place.
                c_out   => c_out,
                V_flag => V_flag_s,
                y       => S);

   
end architecture struct;
