--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
------------------------------------------------- Libraries ----------------------------------------------------
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

------------------------------------------------- Entity -------------------------------------------------------
entity rca_generic is
   generic(width:natural:=32);
   port ( 
         a, b  :  in std_logic_vector(width-1 downto 0);
         c_in  :  in std_logic; -- OBS! Cin may be used in conjunction with negated B input to handle subtraction.
         c_out :  out std_logic;
         V_flag : out std_logic;
         y     :  out std_logic_vector(width-1 downto 0));
end rca_generic;

architecture struct of rca_generic is

--==== Declare Components ====--
component FA is
	port(	Cin		:	in	   STD_LOGIC; 
			A, B	   :	in	   STD_LOGIC;
			S		   :	out   STD_LOGIC;
			Cout	   :	out	STD_LOGIC
	);
end component FA;

signal c_internal:std_logic_vector(width downto 0) := (others=>'0'); -- n carry signals for n-1 bits. LSB=Cin, MSB=Cout

--======== Architecture Body ========--
begin

c_internal(0) <= c_in;
c_out <= c_internal(width);
V_flag <= c_internal(width) xor c_internal(width-1);


rca_struct_gen : for i in 0 to width-1 generate
   fa_gen : FA
   port map(
      a     => a(i), 
      b     => b(i),
      cin   => c_internal(i),
      s     => y(i),
      cout  => c_internal(i+1));
end generate rca_struct_gen;


--fa1: 
--component FA
--port map(a=>a(0), b=>b(0),cin=>'0',s=>y(0),cout=>c(0));
--fa2:
--component FA
--port map(a=>a(1), b=>b(1), cin=> c(0), s=> y(1), cout =>c(1));
--fa3:
--component FA
--port map(a=>a(2), b=>b(2), cin=> c(1), s=> y(2), cout =>c(2));
--fa4:
--component FA
--port map(a=>a(3), b=>b(3), cin=> c(2), s=> y(3), cout =>c(3));

end struct;