--****************************************************************************************************************--
--! @ mux21
--! @ A 2:1 multiplexer. 8-bit  
--
--! Authors: 
--! John William Croft 
--! Alfred Kulldorff
--****************************************************************************************************************--

LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY mux21 IS 
   generic(width : natural := 32);
   PORT (
      mux21_in_0, mux21_in_1 : in STD_LOGIC_VECTOR (width-1 downto 0);
      mux21_sel : in STD_LOGIC;
      mux21_out : OUT STD_LOGIC_VECTOR (width-1 downto 0)
   );
END mux21;

ARCHITECTURE dataflow OF mux21 IS
BEGIN

mux21_out <=   mux21_in_0 	WHEN mux21_sel='0' ELSE 
               mux21_in_1 	WHEN mux21_sel='1' ELSE 
               (others => 'X'); -- X propagation issue. We want 'X' to propagate in case of metastability on the select signal.

END dataflow;

