\begin{code}
\captionof{listing}{Counter}
\label{code:clk\_gen}
    \begin{minted}{vhdl}


library ieee;                  
use ieee.std_logic_1164.all;      
use ieee.numeric_std.all;

entity clk_gen is
   generic( TARGET_FREQ    : natural := 40e3;
            INVERT_CLK_OUT : BOOLEAN := TRUE);
   port (
   clk      : in std_logic; -- nominally 100 MHz
   rst      : in std_logic; -- sync hi reset
   enable   : in std_logic;
   clk_out     :out std_logic;-- 50% duty width
   clk_pulse_out  :out std_logic; -- same freq but only 1 cycle high.
   clk_pulse_out_halfTc : out std_logic -- same as above but shifted by half clock cycle
   );
end entity clk_gen;

architecture rtl of clk_gen is
   constant SYS_CLK : natural := 100E6; --100MHz

   constant CLK_HI  : natural := SYS_CLK/TARGET_FREQ - 1;
   constant CLK_LO  : natural := SYS_CLK/TARGET_FREQ/2-1;
   signal cnt : natural range 0 to CLK_HI;
begin
   process(clk) begin
   if rising_edge(clk) then
      if rst = '1' then 
         cnt <= CLK_HI;
         clk_out <= '0';
         clk_pulse_out <= '0';
      elsif enable = '1' then 
         
         if cnt = CLK_LO then
            if INVERT_CLK_OUT then clk_out <= '1'; else clk_out <= '0'; end if;
            cnt <= cnt + 1;
			clk_pulse_out_halfTc <= '1';
         elsif cnt = CLK_HI then 
            if INVERT_CLK_OUT then clk_out <= '0'; else clk_out <= '1'; end if;
            clk_pulse_out <= '1'; 
            cnt <= 0;
         else
            cnt <= cnt + 1;
            clk_pulse_out <= '0'; 
			clk_pulse_out_halfTc <= '0';
         end if;

      else 
         cnt <= CLK_HI;
         clk_out <= '0';
         clk_pulse_out <= '0';
		 clk_pulse_out_halfTc <= '0';
      end if;
   end if;
   end process;

end architecture rtl;    






\end{minted}
\end{code}