#-- DISCLAIMER OF LIABILITY
#--
#-- This file contains proprietary and confidential information of
#-- Xilinx, Inc. ("Xilinx"), that is distributed under a license
#-- from Xilinx, and may be used, copied and/or disclosed only
#-- pursuant to the terms of a valid license agreement with Xilinx.
#--
#-- XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION
#-- ("MATERIALS") "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
#-- EXPRESSED, IMPLIED, OR STATUTORY, INCLUDING WITHOUT
#-- LIMITATION, ANY WARRANTY WITH RESPECT TO NONINFRINGEMENT,
#-- MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE. Xilinx
#-- does not warrant that functions included in the Materials will
#-- meet the requirements of Licensee, or that the operation of the
#-- Materials will be uninterrupted or error-free, or that defects
#-- in the Materials will be corrected. Furthermore, Xilinx does
#-- not warrant or make any representations regarding use, or the
#-- results of the use, of the Materials in terms of correctness,
#-- accuracy, reliability or otherwise.
#--
#-- Xilinx products are not designed or intended to be fail-safe,
#-- or for use in any application requiring fail-safe performance,
#-- such as life-support or safety devices or systems, Class III
#-- medical devices, nuclear facilities, applications related to
#-- the deployment of airbags, or any other applications that could
#-- lead to death, personal injury or severe property or
#-- environmental damage (individually and collectively, "critical
#-- applications"). Customer assumes the sole risk and liability
#-- of any use of Xilinx products in critical applications,
#-- subject only to applicable laws and regulations governing
#-- limitations on product liability.
#--
#-- Copyright (c) 1995-2010 Xilinx, Inc.  All rights reserved.
#--
#-- This disclaimer and copyright notice must be retained as part
#-- of this file at all times.
#--
###################################################################
##
## Name     : axi_xadc
## Desc     : Microprocessor Peripheral Description
##          : Automatically generated by PsfUtility
##
###################################################################


#***--------------------------------***-----------------------------------***
#
#			     SYSLEVEL_DRC_PROC
#
#***--------------------------------***-----------------------------------***

proc check_syslevel_settings { mhsinst } {

	set incld_intr [xget_hw_parameter_value $mhsinst "C_INCLUDE_INTR"]
	set intr_out   [xget_hw_port_handle $mhsinst "IP2INTC_Irpt"]
	set instname   [xget_hw_parameter_value $mhsinst "INSTANCE"]
	set ipname     [xget_hw_option_value    $mhsinst "IPNAME"]

	if { $incld_intr == 0 && [llength $intr_out] != 0 } {

#		error "\n The port IP2INTC_Irpt of $instname is connected but no interrupt control logic is included.\n" "" "mdt_error"
                puts "\nWARNING: Interrupt has not been enabled.\n"

	} elseif { $incld_intr == 1 && [llength $intr_out] == 0 } {

		puts "\nWARNING:  $instname ($ipname) - Interrupt control logic is included, but IP2INTC_Irpt port not connected.\n"

	}

}

## This procedure sets C_FAMILY to base family
# if the design is targeting a derivative architecture
proc update_cfamily {param_handle} {
    set orig_family [xget_hw_proj_setting "fpga_family"]
            puts "orig_family is $orig_family"
    if  {[xstrncmp $orig_family "virtex7l"]} {
        return "virtex7"
    } elseif  {[xstrncmp $orig_family "kintex7l"]} {
        return "kintex7"
    } else {
        return $orig_family
    }
}

