----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 08/18/2017 01:17:56 PM
-- Design Name: 
-- Module Name: ahb_mst_pkg - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library grlib;
use grlib.amba.all;
use grlib.stdlib.all;


-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

package ahb_mst_pkg is 
    component debouncer is
        Generic ( DEBNC_CLOCKS : INTEGER range 2 to (INTEGER'high) := 2**16;
                  PORT_WIDTH : INTEGER range 1 to (INTEGER'high) := 4);
        Port ( SIGNAL_I : in  STD_LOGIC_VECTOR ((PORT_WIDTH - 1) downto 0);
               CLK_I : in  STD_LOGIC;
               SIGNAL_O : out  STD_LOGIC_VECTOR ((PORT_WIDTH - 1) downto 0));
    end component;
    
    component pdm_to_pcm_wrapper is
       Port (
       fifo_almost_empty : out std_logic;
       fifo_almost_full  : out std_logic;
       fifo_rd_clk       : in std_logic;
       fifo_rd_en        : in std_logic;
       pcm_data          : out std_logic_vector(31 downto 0);
       pdm_clk           : out std_logic;
       pdm_data          : in std_logic;
       resetn            : in std_logic;
       start             : in std_logic;
       sys_clock         : in std_logic
       );
     end component;

    
    type fifo_wr_in_type is record
        full: std_logic;
        almost_empty: std_logic;
    end record;

    type fifo_wr_out_type is record
        data: std_logic_vector(31 downto 0);
        wr_en: std_logic;
    end record;

    type fifo_rd_in_type is record
        data: std_logic_vector(31 downto 0);
        almost_full: std_logic;
        empty: std_logic;
    end record;

    type fifo_rd_out_type is record
        rd_en: std_logic;
    end record;

    component ahb_master_rd
        generic(
            hindex  : integer range 0 to NAHBMST-1  := 0;
            read_size_max : integer range 0 to 511 := 256
        );
        port(
            clk        : in  std_logic;
            resetn     : in  std_logic;
            ahbi       : in  ahb_mst_in_type;
            ahbo       : out ahb_mst_out_type;
            btn        : in std_logic;
            fifo_wr_in : in fifo_wr_in_type;
            fifo_wr_out: out fifo_wr_out_type;
            error_s    : out std_logic
       );
    end component;
    
    component ahb_master_wr is
      generic(
           hindex  : integer range 0 to NAHBMST-1  := 0
      );
      port(clk        : in  std_logic;
           resetn     : in  std_logic;
           ahbi       : in  ahb_mst_in_type;
           ahbo       : out ahb_mst_out_type;
           fifo_rd_in : in fifo_rd_in_type;
           fifo_rd_out: out fifo_rd_out_type;
           error_s    : out std_logic
      );
    end component;

end package;
