library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity demux_16 is
       port(
	     data_tvalid: in std_logic;
             clk: in std_logic;
	    -- a: in std_logic_vector(1 downto 0);  --2 bits a for 4 bits output
	     input_data: in std_logic_vector(15 downto 0);   --hp filter's output is 16 bits, only the second bit works? how to express here?
             
	     output_data_1: out std_logic_vector(15 downto 0));
	     output_data_2: out std_logic_vector(15 downto 0));
	     output_data_3: out std_logic_vector(15 downto 0));
	     output_data_4: out std_logic_vector(15 downto 0));
end entity demux_sync;

architecture arch of demux_sync is
        component demux is 
	port( 
              data_tvalid: in std_logic;
	      clk: in std_logic;
	      input_data: in std_logic;  
	      output_data: out std_logic_vector(3 downto 0));
                    
	end component demux;


signal demux_data:std_logic_vector(3 downto 0):="0000";
signal clk_outQ:std_logic:='0';
signal a: natural range 0 to 3 :=0;
	




begin

        demux_sync_component:
	component demux
	port map( 
	          data_tvalid=>data_tvalid,
                  clk=>clk,
                  input_data=>input_data,
                  output_data=>demux_data);





p0: process(clk)  --not current structure below
       begin
 	    if(falling_edge(clk)) then
	      if (data_tvalid = '1') then
	         if a =3 then
                    a <=0;
                 else
                    a <=a+ 1;
                 end if;
	       end if;   
	    end if;
	 		      
end process p0;





p3: process(a , clk, input_data)
begin
 	if(rising_edge(clk)) then
            if a = 0 then
		output_data <= demux_data; 
            end if;
end if;
		
          
end process p3;
end arch;
