#!/bin/bash

### OBS! OBS! OBS! OBS! OBS! ############################################################################
# Critical BUG                                                                                          #
# When piping simulation straight into external program ie. grep, sim_cycles will be WRONG.             #
# Seemingly, sim_cycles keeps counting an arbitrary amount (ending on a round number eg. 5439900)       #
# This is UNUSABLE         
 # Num of instructions is also wrong!                                                                             #
#########################################################################################################


# For each simulation:
# 1. load standard config
# 2. pass arguments overwriting parameters of interest (ie. cache_size, cache_hit_latency etc...)

HOME=~/simhome
SIM=$HOME/bin/sim-outorder

# Latency lookup table.
declare -A lat_arr
lat_arr[0,2]=1
lat_arr[0,3]=1
lat_arr[0,4]=2
lat_arr[0,5]=2
lat_arr[1,2]=1
lat_arr[1,3]=2
lat_arr[1,4]=2
lat_arr[1,5]=3
lat_arr[2,2]=2
lat_arr[2,3]=2
lat_arr[2,4]=3
lat_arr[2,5]=3
lat_arr[3,2]=2
lat_arr[3,3]=3
lat_arr[3,4]=3
lat_arr[3,5]=4

BLOCK_SIZE=32 # Constant block size throughout tests. Will not affect latency anyway.  


$SIM -config base1.txt  -redir:sim ./tmp $HOME/apps/stringsearch/search_small 
grep -E "sim_CPI|sim_cycle|sim_num_insn" tmp

# Tweak DATA cache
##################
# stringsearch


echo "DATA cache dl1"
echo "==============="
echo ""
echo "stringsearch"
echo "------------"
# 1,2,4,8
# 2**0, 2**1, 2**2, 2**3
for assoc_v in {0..3}
do
    # 4,8,16,32,64
    for sets_v in {2..5}
    do
   LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
   ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
   SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
   CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.

   
   echo "Hit latency: $((LAT))"
	echo "assoc: $ASSOC, cache_size: $((CACHE_SIZE))" 
   #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l
	$SIM -config base1.txt -cache:dl1lat $((LAT)) -cache:dl1 dl1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim ./tmp $HOME/apps/stringsearch/search_small
   grep --color=always -E "sim_CPI|sim_cycle|sim_num_insn" ./tmp   ## This cludgy shit has to be used because of BUG explained above.
	#$SIM -config base1.txt -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim ./tmp $HOME/apps/stringsearch/search_small
   #grep --color=always -E "sim_CPI" ./tmp   ## This cludgy shit has to be used because of BUG explained above.
   #$SIM -config base1.txt  -redir:prog /dev/null -redir:sim ./tmp $HOME/apps/stringsearch/search_small
   #   	$SIM -config base1.txt -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim /dev/stdout $HOME/apps/stringsearch/search_small | grep -E "sim_CPI"
   echo "BUGGZ"
   $SIM -config base1.txt -cache:dl1lat $((LAT)) -cache:dl1 dl1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim /dev/stdout $HOME/apps/stringsearch/search_small | grep --color=always -E "sim_CPI|sim_cycle|sim_num_insn"
   
	 done
    echo "---------------------------------------------------------------"
done

#    echo ""
#    echo "GSM"
#    echo "------------"
#    for assoc_v in {0..3}
#    do
#        for sets_v in {2..5}
#        do
#        LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
#       ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
#       SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
#       CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.
#       
#       echo "Hit latency: $((LAT))"
#    	echo "assoc: $ASSOC, cache_size: $((CACHE_SIZE))" 
#    	$SIM -config base1.txt -cache:dl1lat $((LAT)) -cache:dl1 dl1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim /dev/stdout $HOME/apps/gsm-untoast/untoast -fps -c $SHOME/apps/gsm-untoast/small.au.run.gsm | grep --color=always "sim_CPI"
#    	#$SIM -config base1.txt -cache:dl1 dl1:$((((2**sets)*1024)/(128*$((2**assoc))))):128:$((2**assoc)):l -redir:prog /dev/null -redir:sim /dev/stdout $HOME/apps/gsm-untoast/untoast -fps -c $SHOME/apps/gsm-untoast/small.au.run.gsm | grep --color=always "sim_CPI"
#        done
#        echo "---------------------------------------------------------------"
#    done



rm tmp

