#!/bin/bash

### OBS! OBS! OBS! OBS! OBS! ############################################################################
# Critical BUG                                                                                          #
# When piping simulation straight into external program ie. grep, sim_cycles will be WRONG.             #
# Seemingly, sim_cycles keeps counting an arbitrary amount (ending on a round number eg. 5439900)       #
# This is UNUSABLE         
 # Num of instructions is also wrong!                                                                             #
#########################################################################################################


# For each simulation:
# 1. load standard config
# 2. pass arguments overwriting parameters of interest (ie. cache_size, cache_hit_latency etc...)

SHOME="."
CFG=$2
DIR=$1
SIM="${SHOME}/bin/sim-outorder"

CONFIG=" -config ${SHOME}/configs/${DIR}/${CFG}.txt "
chmod +x bin/*



# Latency lookup table.
declare -A lat_arr
lat_arr[0,2]=1
lat_arr[0,3]=1
lat_arr[0,4]=2
lat_arr[0,5]=2
lat_arr[1,2]=1
lat_arr[1,3]=2
lat_arr[1,4]=2
lat_arr[1,5]=3
lat_arr[2,2]=2
lat_arr[2,3]=2
lat_arr[2,4]=3
lat_arr[2,5]=3
lat_arr[3,2]=2
lat_arr[3,3]=3
lat_arr[3,4]=3
lat_arr[3,5]=4

BLOCK_SIZE=32 # Constant block size throughout tests. Will not affect latency anyway.  


# Tweak DATA cache
##################
# stringsearch


echo "INSTR cache il1" 
echo "==============="
echo ""
echo "stringsearch"
echo "------------"
# 1,2,4,8
# 2**0, 2**1, 2**2, 2**3
for assoc_v in {0..3}
do
    # 4,8,16,32,64
    for sets_v in {2..5}
    do
   LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
   ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
   SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
   CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.

   
   echo "Hit latency: $((LAT)), assoc: $ASSOC, cache_size: $((CACHE_SIZE))"

   #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l
	${SIM} ${CONFIG} -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:prog /dev/null -redir:sim tmp ${SHOME}/apps/stringsearch/search_small  
	grep --color=always -E "sim_CPI" ./tmp   

   
	 done
    echo "---------------------------------------------------------------"
done


 echo ""
 echo "jpeg"
 echo "------------"
 # 1,2,4,8
 # 2**0, 2**1, 2**2, 2**3
 for assoc_v in {0..3}
 do
     # 4,8,16,32,64
     for sets_v in {2..5}
     do
    LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
    ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
    SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
    CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.
 
    
    echo "Hit latency: $((LAT)), assoc: $ASSOC, cache_size: $((CACHE_SIZE))"
 
    #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l
 
    ${SIM}  ${CONFIG} -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:sim tmp ${SHOME}/apps/jpeg-cjpeg/cjpeg -dct int -progressive -opt -outfile ${SHOME}/configs/${DIR}/jpeg-cjpeg_output_small_encode.jpeg ${SHOME}/apps/jpeg-cjpeg/input_small.ppm
    grep --color=always -E "sim_CPI" ./tmp   
    
 	 done
     echo "---------------------------------------------------------------"
 done





 echo ""
 echo "gsm"
 echo "------------"
 # 1,2,4,8
 # 2**0, 2**1, 2**2, 2**3
 for assoc_v in {0..3}
 do
     # 4,8,16,32,64
     for sets_v in {2..5}
     do
    LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
    ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
    SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
    CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.
 
    
    echo "Hit latency: $((LAT)), assoc: $ASSOC, cache_size: $((CACHE_SIZE))"
 
    #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l
 
    ${SIM} ${CONFIG} -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l -redir:sim tmp ${SHOME}/apps/gsm-untoast/untoast -fps -c ${SHOME}/apps/gsm-untoast/small.au.run.gsm > ${SHOME}/configs/${DIR}/gsm-untoast-output_small.decode.run
    grep --color=always -E "sim_CPI" ./tmp
    
 	 done
     echo "---------------------------------------------------------------"
 done




 echo ""
 echo "qsort"
 echo "------------"
 # 1,2,4,8
 # 2**0, 2**1, 2**2, 2**3
 for assoc_v in {0..3}
 do
     # 4,8,16,32,64
     for sets_v in {2..5}
     do
    LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
    ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
    SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
    CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.
 
    
    echo "Hit latency: $((LAT)), assoc: $ASSOC, cache_size: $((CACHE_SIZE))"
 
    #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l  
 
    ${SIM} ${CONFIG} -redir:sim tmp -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l ${SHOME}/apps/qsort/qsort_small  ${SHOME}/apps/qsort/input_small.dat > ${SHOME}/configs/${DIR}/qsort_small-output.txt
    grep --color=always -E "sim_CPI" ./tmp   
    
 	 done
     echo "---------------------------------------------------------------"
 done








 echo ""
 echo "dijkstra"
 echo "------------"
 # 1,2,4,8
 # 2**0, 2**1, 2**2, 2**3
 for assoc_v in {0..3}
 do
     # 4,8,16,32,64
     for sets_v in {2..5}
     do
    LAT="${lat_arr[$((assoc_v)),$((sets_v))]}"       # latency from lookup table
    ASSOC=$((2**assoc_v))                            # N-way associative cache (directly set)
    SETS=$((2**sets_v*1024))/$((BLOCK_SIZE*ASSOC))   # No. of sets will determine total cache size, assuming block_size and association known. Total cache size also known.
    CACHE_SIZE=$(($((SETS))*$((ASSOC))*BLOCK_SIZE))  # Product of assoc., nsets and block_size.
 
    
    echo "Hit latency: $((LAT)), assoc: $ASSOC, cache_size: $((CACHE_SIZE))"
 
    #                                     SYNTAX: -cache:dl1 dl1:<nsets>:<bsize>:<assoc>:l
    ${SIM} ${CONFIG} -redir:prog /dev/null -redir:sim tmp -cache:il1lat $((LAT)) -cache:il1 il1:$((SETS)):$((BLOCK_SIZE)):$((ASSOC)):l ${SHOME}/apps/dijkstra/dijkstra_small  ${SHOME}/apps/dijkstra/input.dat 
 	grep --color=always -E "sim_CPI" ./tmp   
 
    
 	 done
     echo "---------------------------------------------------------------"
 done

  rm tmp








