% Constants in celestial mechanics

c2k = @(c) c + 273.15; % Convert Celcius to Kelvin.
k2c = @(k) k - 273.15; % Convert Celcius to Kelvin.

G    = 6.6720e-11; % [m^3 s^-2 kg^-1] Gravitational constant.
M_E  = 5.9742e24;  % [kg] Mass of the Earth
R_E  = 6378e3;     % [m] Radius of Earth(equatorial).

M_S  = 1.9891e30;  % [kg] Mass of the Sun

g    = 9.81;       % [m s^-2] Acceleration of gravity near Earth. G*M_E/R_E^2

amu  = 1.66057e-27; % [kg] atomic mass unit/Dalton. https://en.wikipedia.org/wiki/Dalton_(unit) 
AU = 149.56e9; % [m] Astronomical Unit (distance Earth-Sun)
axial_tilt_of_earth = 23.5; % deg
omega_E = 7.292e-5; % [rad s^-1]


sidereal_day = 86164; % [s]
solar_day = 60*60*24; % [s]


solar_constant = 1371; %  [W m^-2] Irradiance (radiant flux per unit area) from Sun to Earth (distance 1AU).

% Properties of the Moon.
moon.M = 7.35e22; % mass [kg]
moon.R = 1738e3;  % radius [m]
moon.a = 384400e3;% Semi-major axis [m]
moon.e = 0.06;    % Eccentricity
moon.T = 27.32/365; % Orbital period [years]

sun.R = 696340e3; % radius [m]
sun.Temp = 5778; % Surface temp. of Sun. [k] 

% Properties of the Mercury.
merc.M = 3.3e23; % mass [kg]
merc.R = 2439e3;  % radius [m]
merc.a = 0.387*AU;% Semi-major axis [m]
merc.e = 0.206;    % Eccentricity
merc.T = 0.2408; % Orbital period [years]
merc.Temp = 700; % surface temp. [k]






