%% Hohmann transfer
% Earth -> mercury 
constants
% Astronomical Unit
AU = 149.56e9;

% Orbit of Earth around Sun.
VE = sqrt(G*(M_S+M_E)/AU);

% Orbit of Neptune around Sun
M_M = 3.30e23; % Mass of mercury
dM  = 0.387*AU; % Distance from sun to mercury. (assuming roughly circular orbit)
dE  = AU;
VM = sqrt(G*(M_S+M_M)/dM); % Should be 48km/s

% Velocity at peri- and apoapsis of elliptical transfer orbit.
Vp = sqrt(2*G*M_S/dM*dE/(dE+dM))
Va = sqrt(2*G*M_S/dE*dM/(dM+dE))

% Delta
dV1 = Va - VE % Velocity delta at perihelion.
dV2 = VM - Vp %

dVtot = dV1 + dV2

% Time taken in maneuver (using K3)
a = 0.5*(dM + dE)

T = 2*pi*sqrt(a^3/(G*M_S)) % Time for full orbit of ellipse.
Ttransit = T/2 / 60/60/24 % 


% Sphere of influence.
r_SOI = AU*(M_E/M_S)^(2/5); % Radius of sphere of influence of earth.
V_SOI = sqrt(G*M_E/r_SOI)   % Velocity at SOI. ~650 m/s
