% Displays the FIR filter coefficients for the OFDM-lab bandpass prefilter.
% Bandpass filter used to remove out-of-(OFDM)-band disturbances. Filter
% order must be low as the filter dynamics will extend the channel
% impulse response, consuming the cyclic prefix.
% For an upsampling factor of 8, using a FIR-filter order of 16 gives
% reasonable performance while "only" consuming 2 base-band samples.

clc;
clear all; %#ok<CLALL>
close all;
format short eng;

% MATLAB Code
% Generated by MATLAB(R) 9.2 and the DSP System Toolbox 9.4.
% Generated on: 10-Oct-2017 14:40:06

% Equiripple Bandpass filter designed using the FIRPM function.

% All frequency values are in Hz.
Fs = 16000;  % Sampling Frequency

N      = 16;    % Order
Fstop1 = 2000;  % First Stopband Frequency
Fpass1 = 3000;  % First Passband Frequency
Fpass2 = 5000;  % Second Passband Frequency
Fstop2 = 6000;  % Second Stopband Frequency
Wstop1 = 1;     % First Stopband Weight
Wpass  = 1;     % Passband Weight
Wstop2 = 1;     % Second Stopband Weight
dens   = 20;    % Density Factor

% Calculate the coefficients using the FIRPM function.
b  = firpm(N, [0 Fstop1 Fpass1 Fpass2 Fstop2 Fs/2]/(Fs/2), [0 0 1 1 0 ...
           0], [Wstop1 Wpass Wstop2], {dens});
Hd = dfilt.dffir(b);


% Draw plot of frequency response and coefficient values
freqz(Hd);
impulse(Hd);

% Generate a C-compatible string containing filter coefficients in reversed
% order
str_prefix = 'float ofdm_bpfilt_coeffs[] = {';
str_postfix = '};';

str = str_prefix;
for i=length(Hd.Numerator):-1:1
	str = sprintf('%s%.10e',str, Hd.Numerator(i));
	if(i > 1)
		str = sprintf('%s, ', str);
	end
end
str = sprintf('%s%s', str, str_postfix);
disp(str);
